package com.blt.other.auth.controller;


import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.auth.model.OaDepartment;
import com.blt.other.auth.service.IOaDepartmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Api("/oa公司接口")
@RestController
@RequestMapping("/oaDepartment")
public class OaDepartmentController {

    @Resource
    IOaDepartmentService oaDepartmentService;

    @ApiOperation("获取百伦公司主体下面的一级部门列表")
    @GetMapping("/primaryDepartment")
    public CostResult<List<OaDepartment>> oaDepartment(@RequestParam Integer companyId) {
        List<OaDepartment> oaDepartmentList = oaDepartmentService.oaDepartment(companyId);
        return CostResult.success(oaDepartmentList);
    }
}
