package com.blt.other.module.cost.service;

import com.blt.other.module.cost.dto.request.AddItemReq;
import com.blt.other.module.cost.dto.request.AddItemResp;
import com.blt.other.module.cost.dto.request.ResetItemReq;
import com.blt.other.module.cost.dto.response.GetCostTempByPlanNoResp;
import com.blt.other.module.database.model.CostPlanTempDomain;
import org.springframework.lang.NonNull;

import java.math.BigDecimal;

public interface CostPlanTempService {

    String createNo();

    /**
     * <p>保存费用计划详情项</p>
     *
     * @param req 费用计划模板
     * @return resp
     */
    AddItemResp doSave(AddItemReq req);


    /**
     * <p>
     * 获取费用计划详情
     * </p>
     *
     * @param costPlanNo 费用编号
     * @return 费用计划行
     */
    GetCostTempByPlanNoResp getTempListByPlanNo(String costPlanNo);

    /**
     * <p>
     * 根据费用计划单号和计划单项编号删除计划单项
     * </p>
     *
     * @param costPlanNo 计划单号no
     * @param tempNo     计划单项no
     * @return 删除计划单项后的计划单的总费用
     */
    BigDecimal deleteItemByPlanNoAndTempNo(String costPlanNo, String tempNo);

    /**
     * <p>
     * 根据费用计划单项编号查询费用计划单项
     * * </p>
     *
     * @param tempNo 用计划单项编号
     * @return 费用计划单项
     */
    @NonNull
    CostPlanTempDomain getByTempNo(@NonNull String tempNo);

    /**
     * <p>
     * 更新费用计划子项
     * </p>
     *
     * @param req req
     * @return resp
     */
    CostPlanTempDomain resetItem(ResetItemReq req);
}
