package com.blt.other.module.purchasing.controller;

import com.bailuntec.cost.api.BuyApi;
import com.bailuntec.cost.api.domain.BuyDomain;
import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.purchasing.service.BuyApiService;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/buy/api")
public class BuyApiController implements BuyApi {

    @Autowired
    private BuyApiService buyApiService;

    private static Logger logger = LoggerFactory.getLogger(BuyApiController.class);

    @ApiOperation("获取资产负债表相关采购单")
    @GetMapping("/balanceSheetBuy")
    public CostResult<List<BuyDomain>> balanceSheetBuyList(@RequestParam(name = "startDate") String startDateStr,
                                                           @RequestParam(name = "endDate") String endDateStr) throws ParseException {
        logger.warn("获取资产负债表相关采购单");
        Map<String, Object> result = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = sdf.parse(startDateStr);
        Date endDate = sdf.parse(endDateStr);
        List<BuyDomain> balanceSheetBuyList = buyApiService.getBalanceSheetBuy(startDate, endDate);
        return CostResult.success(balanceSheetBuyList);
    }
}
