package com.blt.other.other_cost.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.CurUtils;
import com.blt.other.other_cost.dto.CostPlanDto;
import com.blt.other.other_cost.dto.CostPlanTempDto;
import com.blt.other.other_cost.service.CostPlanService;
import com.blt.other.other_cost.service.CostPlanTempService;
import com.blt.other.other_database.model.CostPlanDomain;
import com.blt.other.other_database.model.CostPlanTempDomain;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/cost/plan")
public class CostPlanController {

    @Autowired
    private CostPlanService costPlanService;

    @Value("${url.api.getExchangeRateApi}")
    private String getExchangeRateApi;

    @Autowired
    private CostPlanTempService costPlanTempService;
    @GetMapping("/getAllCostPlan")
    public Map<String,Object> getAllCostPlan(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String pageNumStr = request.getParameter("pageNum");
        Integer pageNum = null;
        String pageSizeStr = request.getParameter("pageSize");
        Integer pageSize = null;
        Integer userId = (request.getParameter("userId") == null ? null : Integer.valueOf(request.getParameter("userId")));
        Integer authType = (request.getParameter("authType") == null ? 0 : Integer.valueOf(request.getParameter("authType")));
        if (null != pageNumStr && null != pageSizeStr){
            pageNum = Integer.parseInt(pageNumStr);
            pageSize = Integer.parseInt(pageSizeStr);
        }
        PageHelper.startPage(pageNum,pageSize);
        if(authType != 0) {
            userId = null;
        }
        List<CostPlanDomain> allCostList = costPlanService.getAllCostList(userId);
        PageInfo<CostPlanDomain> pageInfo = new PageInfo<>(allCostList);
        List<CostPlanDto> costPlanDtos = costPlanService.domainListToDtoList(allCostList);
        result.put("success",true);
        result.put("plans",costPlanDtos);
        result.put("pageInfo",pageInfo);
        return result;
    }

    @PostMapping("getCostPlan")
    public Map<String,Object> getCostPlan(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String costPlanNo = request.getParameter("costPlanNo");
        CostPlanDomain byPlanNo = costPlanService.getByPlanNo(costPlanNo);
        String filePath = byPlanNo.getFilePath();
        String fileName = null;
        if (null != filePath && filePath.length() >= 1){
            String[] split = filePath.split("&");
            if (null != split && split.length >= 1){
                fileName = split[split.length-1];
            }
        }
        Map<String,Object> result = new HashMap<>();
        result.put("costPlan",byPlanNo);
        result.put("fileName",fileName);
        return result;
    }

    @PostMapping("getPlanTmps")
    public Map<String,Object> getPlanTmps(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        String costPlanNo = request.getParameter("costPlanNo");
        List<CostPlanTempDto> tempListByPlanNo = costPlanTempService.getTempListByPlanNo(costPlanNo);
        BigDecimal planAmount = new BigDecimal(0);
        if (null != tempListByPlanNo && tempListByPlanNo.size() >= 1){
            for (CostPlanTempDto dto : tempListByPlanNo){
                BigDecimal cny = CurUtils.getCur(dto.getDic(), "CNY", getExchangeRateApi);
                planAmount = planAmount.add(dto.getAmount().multiply(cny));
            }
        }
        Map<String,Object> result = new HashMap<>();
        result.put("tmps",tempListByPlanNo);
        result.put("planAmount",planAmount.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue());
        return result;
    }


    @GetMapping("download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        AxiosUtil.setCors(response,request);
        String costPlanNo = request.getParameter("costPlanNo");

        CostPlanDomain byPlanNo = costPlanService.getByPlanNo(costPlanNo);
        String filePath = null;
        String fileName = null;
        if (null != byPlanNo) {
            filePath = byPlanNo.getFilePath();
            if (null != filePath && filePath.contains("&")){
                String[] split = filePath.split("&");
                if (null != split && split.length>=1){
                    fileName = split[split.length-1];
                }
            }
        }

        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"),"iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }
}
