package com.blt.other.module.purchasing.service.impl;

import com.blt.other.module.database.model.*;
import com.blt.other.module.purchasing.dao.BuyDao;
import com.blt.other.module.purchasing.dao.BuyPlanDao;
import com.blt.other.module.purchasing.dao.BuyPlanDetailDao;
import com.blt.other.module.purchasing.dao.PlanSkuTempDao;
import com.blt.other.module.purchasing.service.BuyPlanDetailService;
import com.blt.other.module.purchasing.service.PlanSkuTempService;
import com.blt.other.module.sku.dao.SysProductDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Service
public class BuyPlanDetailServiceImpl implements BuyPlanDetailService {

    private static Logger logger = LoggerFactory.getLogger(BuyPlanDetailServiceImpl.class);

    @Autowired
    private BuyPlanDetailDao buyPlanDetailDao;

    @Autowired
    private SysProductDao sysProductDao;

    @Autowired
    private PlanSkuTempService planSkuTempService;

    @Autowired
    private BuyDao buyDao;

    @Autowired
    private BuyPlanDao buyPlanDao;
    @Autowired
    private PlanSkuTempDao planSkuTempDao;

    @Override
    public List<BuyPlanDetailDomain> getBuyPlanDetailByno(String no) {

        return buyPlanDetailDao.selectBuyPlanDetailByno(no);
    }

    @Override
    public String saveNewBuyPlanDetail(String no, String company, String department, String blUserAcct) {
        // 根据 no 获取 plan_sku_tem 中的信息
        List<PlanSkuTempDomain> allByNo = planSkuTempService.getAllByNo(no);
        // 将获取到的 list 遍历，根据每条记录，从 sku 系统获取 detail
        if (allByNo != null && allByNo.size()>=1){
            for (PlanSkuTempDomain planSkuTempDomain : allByNo){
                List<SysProductDomain> list = sysProductDao.selectByKeyword(planSkuTempDomain.getSkucode());
                if (list != null && list.size()>=1){
                    // 将获取到的 SysProductDomain 转成 BuyPlanDetailDomain
                    BuyPlanDetailDomain buyPlanDetailDomain = sysProductDomainToBuyPlanDetailDomain(list.get(0));
                    buyPlanDetailDomain.setNo(no);
                    buyPlanDetailDomain.setCount(planSkuTempDomain.getSkucount());
                    // BigDecimal 计算 sku 总价
                    Integer skucount = planSkuTempDomain.getSkucount();
                    BigDecimal count = new BigDecimal(skucount);
                    BigDecimal skuprice = planSkuTempDomain.getSkuprice();
                    BigDecimal amount = count.multiply(skuprice);
                    buyPlanDetailDomain.setAmount(amount);
                    buyPlanDetailDomain.setIsurgency(0);
                    buyPlanDetailDomain.setIsdelete(0);
                    Integer insertResult = buyPlanDetailDao.insertBuyPlanDetail(buyPlanDetailDomain);
                }
            }
            // 清除缓存的表中的缓存数据
            Integer del = planSkuTempDao.deleteByNo(no);
            logger.info(no+" 清理 "+del+" 条商品缓存");
            return "成功保存/修改buy_plan-detail";
        }
        return "没有添加商品";
    }

    /**
     * 将主管审核通过后的的计划单按照不同的 detail 生成采购单
     * @return
     */
    @Override
    public String saveNewBuyToBuy( String no) {
        // 根据传送过来的 no ，分别从 buy_plan 和 buy_plan_detail 表中获取信息，生成采购单
        // 1、根据 no 从 buy_plan 和 buy_plan_detail 表中获取信息
//        String no = map.get("no");
        List<BuyPlanDomain> list = buyPlanDao.selectBuyPlanByNo(no);
        BuyPlanDomain buyPlanDomain = null;
        // 用于生成采购单号
        Random random = new Random();
        Integer result = 0;
        if (null != list && list.size() >= 1){
            buyPlanDomain = list.get(0);
//            logger.info("采购计划单号："+no+"从采购计划表中获取基本信息："+buyPlanDomain);
        }
        List<BuyPlanDetailDomain> buyPlanDetailDomains = buyPlanDetailDao.selectBuyPlanDetailByno(no);
        logger.info("采购计划单号："+no+" 在 buy_plan_detail 中有 "+buyPlanDetailDomains.size()+" 条记录");
        if (null != buyPlanDetailDomains && buyPlanDetailDomains.size() >= 1){
            BuyDomain buyDomain = null;
            List<String> buyList = new ArrayList<>();
            for (BuyPlanDetailDomain buyPlanDetailDomain : buyPlanDetailDomains){
                // 2、将获取到到 bean 转化为 BuyDomain
                buyDomain = new BuyDomain();
                logger.info("采购计划单号："+no+" 的基本记录"+buyPlanDomain.toString()+" 开始生成采购单信息");
                BeanUtils.copyProperties(buyPlanDomain,buyDomain);
                logger.info("采购计划单号："+no+" 的详细信息"+buyPlanDetailDomain.toString()+" 开始生成采购单信息");
                BeanUtils.copyProperties(buyPlanDetailDomain,buyDomain);
                // TODO 补充 BuyDomain 剩余的参数
                buyDomain.setBuyno("B"+System.currentTimeMillis()+random.nextInt(10));
                buyDomain.setBuyno(buyDomain.getBuyno()+random.nextInt(10));
                buyDomain.setBuystatus(0);
                buyDomain.setPaystatus(0);
                buyDomain.setSendstatus(0);
                buyDomain.setPaycompanyname(buyDomain.getCompany());
                // 3、将 BuyDomain 保存到 buy 表中
                //  查询是否有相同的 no 相同的 skucode
                List<BuyDomain> buyDomains = buyDao.selectByNoAndSkucode(buyDomain);
                if (null != buyDomains && buyDomains.size() >= 1){
                    return "采购单已存在，如需修改请到采购单详情页操作";
                }
                logger.info("开始生成采购单："+buyDomain.toString());
                Integer insert = buyDao.insert(buyDomain);
                result += insert;
                buyList.add(buyDomain.getBuyno());
            }
            // 将所生成的所有采购单号以 list 格式保存到 buy_plan 表中
            BuyPlanDomain buyPlanDomainForSetPurids = new BuyPlanDomain();
            logger.warn("采购计划对应的采购单列表"+buyList);
            buyPlanDomainForSetPurids.setPurids(buyList.toString());
//            buyPlanDomainForSetPurids.setRemark("abcd");
            buyPlanDomainForSetPurids.setNo(buyDomain.getNo());
            buyPlanDao.updateBuyPlan(buyPlanDomainForSetPurids);

            Integer integer = buyPlanDao.updateBuyPlan(buyPlanDomainForSetPurids);
            if (null != integer && integer >= 1){
                logger.warn("采购计划单："+no+" 已经添加对应的采购单号"+buyList);
            }
        }
        return ""+result;
    }

    @Override
    public void delete(String no, String skucode) {
        buyPlanDetailDao.delete(no,skucode);
    }

    @Override
    public Integer save(BuyPlanDetailDomain detailDomain) {
        SysProductDomain sysProductDomain = sysProductDao.selectBySkucode(detailDomain.getSkucode());
        detailDomain.setAmount(sysProductDomain.getSkuprice().multiply(new BigDecimal(detailDomain.getCount())));
        detailDomain.setPrice(sysProductDomain.getSkuprice());
        detailDomain.setSkucolor(sysProductDomain.getSkucolor());
        detailDomain.setSkuname(sysProductDomain.getSkuname());
        detailDomain.setSkusize(sysProductDomain.getSkusize());
        detailDomain.setSuppliername(sysProductDomain.getSuppliername());
        detailDomain.setSupplierid(sysProductDomain.getSupplierid());
        detailDomain.setSupplierNo(sysProductDomain.getSupplierNo());
        Integer integer = buyPlanDetailDao.insertBuyPlanDetail(detailDomain);
        return integer;
    }

    /**
     *
     * @param detail
     * @return
     */
    @Override
    public Integer update(BuyPlanDetailDomain detail) {
        return buyPlanDetailDao.update(detail);
    }

    @Override
    public BuyPlanDetailDomain getByNoAndSkucode(String no, String skucode) {
        BuyPlanDetailDomain buyPlanDetailDomain = buyPlanDetailDao.selectBuyNoAndSkucode(no,skucode);
        if (null != buyPlanDetailDomain && null != buyPlanDetailDomain.getId()){
            return buyPlanDetailDomain;
        }
        return null;
    }


    /**
     * 将获取到的 SysProductDomain 转成 BuyPlanDetailDomain
     * @param sysProductDomain
     * @return
     */
    private BuyPlanDetailDomain sysProductDomainToBuyPlanDetailDomain(SysProductDomain sysProductDomain){
        BuyPlanDetailDomain buyPlanDetailDomain = new BuyPlanDetailDomain();
        BeanUtils.copyProperties(sysProductDomain,buyPlanDetailDomain);
        buyPlanDetailDomain.setId(null);
        buyPlanDetailDomain.setPrice(sysProductDomain.getSkuprice());
        return buyPlanDetailDomain;
    }
}
