package com.blt.other.module.cost.service.impl.cost;

import com.bailuntec.common.SpringContextUtil;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/17 10:13 上午
 */
public final class CostServiceFactory {

    public static CostService getCostService() {
        return SpringContextUtil.getBean(DefaultCostServiceImpl.class);
    }


    public static CostService getCostService(String costNo) {
        CostDao costDao = SpringContextUtil.getBean(CostDao.class);
        return getCostService(costDao.selectByCostNo(costNo));
    }

    public static CostService getCostService(CostDomain costDomain) {

        if (costDomain.getCostForm().equals(1)) {
            return SpringContextUtil.getBean(PayCostServiceImpl.class);
        }
        if (costDomain.getCostForm().equals(2)) {
            return SpringContextUtil.getBean(ReceiptCostServiceImpl.class);
        }
        if (costDomain.getCostForm().equals(3) && costDomain.getIsLend().equals(1)) {
            return SpringContextUtil.getBean(Lend1CostServiceImpl.class);
        }
        if (costDomain.getCostForm().equals(3) && costDomain.getIsLend().equals(2)) {
            return SpringContextUtil.getBean(Lend2PayCostServiceImpl.class);
        }
        return SpringContextUtil.getBean(DefaultCostServiceImpl.class);
    }
}


