package com.blt.other.module.cost.service.impl;

import com.bailuntec.cost.api.dto.CostTypeKindDto;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.dao.CostTypeDao;
import com.blt.other.module.cost.dao.CostTypeKindDao;
import com.blt.other.module.cost.dao.LogisticsSupplierBankDao;
import com.blt.other.module.cost.service.CostTypeKindService;
import com.blt.other.module.database.mapper.StatusMapper;
import com.blt.other.module.database.model.*;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class CostTypeKindServiceImpl implements CostTypeKindService {
    private static Logger logger = LoggerFactory.getLogger(CostTypeKindServiceImpl.class);
    @Autowired
    private CostTypeKindDao costTypeKindDao;
    @Autowired
    private StatusMapper statusMapper;
    @Autowired
    private CostTypeDao costTypeDao;
    @Autowired
    private CostCompanyDao costCompanyDao;
    @Autowired
    private UserDao userDao;

    @Autowired
    private LogisticsSupplierBankDao logisticsSupplierBankDao;

    @Override
    public List<CostTypeKindDto> getAllKind() {
        List<CostTypeKindDomain> costTypeKindDomains = costTypeKindDao.selectAll();
        return getDtoList(costTypeKindDomains);
    }

    /**
     * 分页获取所有费用小类
     *
     * @param pageSize
     * @param pageNum
     * @return
     */
    @Override
    public Map<String, Object> getAllKindWithPage(Integer pageNum, Integer pageSize) {
        Map<String, Object> result = new HashMap<>();
        PageHelper.startPage(pageNum, pageSize);
        List<CostTypeKindDomain> costTypeKindDomains = costTypeKindDao.selectAll();
        PageInfo<CostTypeKindDomain> pageInfo = new PageInfo<>(costTypeKindDomains);

        List<CostTypeKindDto> dtoList = getDtoList(costTypeKindDomains);
        result.put("kinds", dtoList);
        result.put("pageInfo", pageInfo);

        return result;
    }

    @Override
    public List<CostTypeKindDto> getListByTypeNo(String typeNo) {
        List<CostTypeKindDomain> costTypeKindDomains = costTypeKindDao.selectByTypeNo(typeNo);
        List<CostTypeKindDto> dtoList = getDtoList(costTypeKindDomains);
        return dtoList;
    }

    @Override
    public List<CostTypeKindDto> getListByCompanyNo(String companyNo) {
        List<CostTypeKindDomain> costTypeKindDomains = costTypeKindDao.selectByCompanyNo(companyNo);
        return getDtoList(costTypeKindDomains);
    }

    /**
     * 保存费用种类记录
     *
     * @return
     */
    @Override
    public Integer saveNewKind(CostTypeKindDomain costTypeKindDomain) {
        // 是否已经存在相同 typeNo 、kindName 的记录
        CostTypeKindDomain costTypeDomain = costTypeKindDao.selectByTypeNoAndKindName(costTypeKindDomain);
        if (null != costTypeDomain && null != costTypeDomain.getTypeNo()) {
            return null;
        }
        // 执行 doInsert()
        Integer integer = doInsert(costTypeKindDomain);
        return integer;
    }

    /**
     * 根据 kindNo 获取费用单详情
     *
     * @param kindNo
     * @return
     */
    @Override
    public CostTypeKindDomain getKindByKindNo(String kindNo) {
        return costTypeKindDao.selectByKindNo(kindNo);
    }


    /**
     * Excel 导入费用小类
     *
     * @param file
     * @return
     * @throws Exception
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean importByExcel(MultipartFile file, String createUsercode) throws Exception {
        boolean notNull = false;
        boolean isExcel2003 = true;
        String fileName = file.getOriginalFilename();
        if (fileName.matches("^.+\\.(?i)(xlsx)$")) {
            isExcel2003 = false;
        }
        InputStream is = file.getInputStream();
        Workbook wb = null;
        if (isExcel2003) {
            wb = new HSSFWorkbook(is);
        } else {
            wb = new XSSFWorkbook(is);
        }
        if (null != wb) {
            List<CostTypeKindDomain> list = new ArrayList<>();
            for (int s = 0; s < wb.getNumberOfSheets(); s++) {
                Sheet sheet = wb.getSheetAt(s);
                if (sheet != null) {
                    notNull = true;
                    CostTypeKindDomain costTypeKindDomain;
                    String typeName = "";
                    for (int r = 1; r <= sheet.getLastRowNum(); r++) {
                        Row row = sheet.getRow(r);
                        if (row == null) {
                            continue;
                        }
                        if (null == row.getCell(0) || String.valueOf(row.getCell(0).getNumericCellValue()).isEmpty()) {
//                            超出的多余行数，跳过
                            continue;
//                            System.out.print("序号1 ");
                        } else if (null == row.getCell(0) || row.getCell(0).getNumericCellValue() == 0) {
//                            System.out.print("序号2 ");
//                            超出的多余行数，跳过
                            continue;
                        } else {
                        }

                        costTypeKindDomain = new CostTypeKindDomain();
                        CostCompanyDomain companyDomain = null;
                        if (null == row.getCell(1) || row.getCell(1).getStringCellValue().isEmpty()) {
                            throw new RuntimeException("sheet" + (s + 1) + "  " + "第 " + (r) + " 行公司主体不能为空");
                        } else {
                            // 根据公司主体名称获取主体信息，不存在则抛出异常
                            String companyName = row.getCell(1).getStringCellValue();
                            companyDomain = costCompanyDao.selectByName(companyName);
                            if (null == companyDomain || null == companyDomain.getCompanyNo()) {
                                throw new RuntimeException("sheet" + (s + 1) + "  " + "第 " + (r) + " 行公司主体不存在或主体信息不全");
                            }
                            costTypeKindDomain.setCompanyNo(companyDomain.getCompanyNo());
                            costTypeKindDomain.setCompanyName(companyDomain.getCompanyName());
                        }

                        // 科目编码  第 2 列
                        if (null != row.getCell(2)) {
                            row.getCell(2).setCellType(Cell.CELL_TYPE_STRING);
                            if (!row.getCell(2).getStringCellValue().isEmpty()) {
                                costTypeKindDomain.setSubjectCode(row.getCell(2).getStringCellValue());
                            } else {
                                throw new RuntimeException("sheet" + (s + 1) + "  " + "第 " + (r) + " 科目编码不明确");
                            }
                        } else {
                            throw new RuntimeException("sheet" + (s + 1) + "  " + "第 " + (r) + " 科目编码不明确");
                        }

                        // 大类 第 5 列
                        if ((null != row.getCell(5) && !row.getCell(5).getStringCellValue().isEmpty())) {
                            typeName = row.getCell(5).getStringCellValue();
//                            11111111(companyDomain.getCompanyName()+"  "+typeName);

                            saveTypePIO(companyDomain, typeName, row, s, r);
                        }
                        CostTypeDomain typeDomain = costTypeDao.selectByCompanyNameAndTypeName(companyDomain.getCompanyName(), typeName);
                        if (null == typeDomain) {
                            typeDomain = saveTypePIO(companyDomain, typeName, row, s, r);
//                            throw new RuntimeException("sheet"+(s+1)+"  "+"第 "+(r)+ " null");
                        } else {
                            typeDomain = setCostForm(typeDomain, row, s, r);
                        }
                        costTypeKindDomain.setTypeNo(typeDomain.getTypeNo());
                        costTypeKindDomain.setTypeName(typeName);
                        costTypeKindDomain.setCostForm(typeDomain.getCostForm());
                        costTypeKindDomain.setIsLend(typeDomain.getIsLend());

                        //　小类　第　6　列
                        costTypeKindDomain.setKindName(row.getCell(6).getStringCellValue());
                        CostTypeKindDomain costTypeKind = costTypeKindDao.selectByTypeNoAndKindName(costTypeKindDomain);
                        if (null != costTypeKind && null != costTypeKind.getKindName()) {
                            continue;
                        }
                        costTypeKindDomain.setKindNo(createKindNo());
                        costTypeKindDomain.setId(r);
                        costTypeKindDomain = setCreateUser(costTypeKindDomain, createUsercode);
                        list.add(costTypeKindDomain);
                    }
                }
            }
            // 将导入的小类列表加入数据库
            if (null != list && list.size() >= 1) {
                for (CostTypeKindDomain costTypeKindDomain : list) {
                    CostTypeKindDomain costTypeKindDomainGet = costTypeKindDao.selectByKindNo(costTypeKindDomain.getKindNo());
                    while (null != costTypeKindDomainGet) {
                        costTypeKindDomain.setKindNo(createKindNo());
                        costTypeKindDomainGet = costTypeKindDao.selectByKindNo(costTypeKindDomain.getKindNo());
                    }
                    // TODO try 重复的 kindNo
                    costTypeKindDao.insert(costTypeKindDomain);
                }
            }
        }
        return notNull;
    }

    private CostTypeKindDomain setCreateUser(CostTypeKindDomain costTypeKindDomain, String createUsercode) {
        UserDomain select = userDao.select(createUsercode);
        costTypeKindDomain.setCreateUsercode(createUsercode);
        costTypeKindDomain.setCreateUsername(select.getUsername());
        return costTypeKindDomain;
    }

    @Override
    public Integer update(CostTypeKindDomain costTypeKindDomain) {
        if (null != costTypeKindDomain.getTypeNo()) {
            CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNo(costTypeKindDomain.getTypeNo());
            costTypeKindDomain.setTypeName(costTypeDomain.getTypeName());
            costTypeKindDomain.setCompanyNo(costTypeDomain.getCompanyNo());
            costTypeKindDomain.setCompanyName(costTypeDomain.getCompanyName());
        }
        Integer i = costTypeKindDao.update(costTypeKindDomain);
        return i;
    }

    @Override
    public Integer deleteKind(String kindNo) {
        return costTypeKindDao.delete(kindNo);
    }

    private CostTypeDomain saveTypePIO(CostCompanyDomain companyDomain,
                                       String typeName,
                                       Row row,
                                       Integer s,
                                       Integer r) {
        CostTypeDomain type = costTypeDao.selectByCompanyNameAndTypeName(companyDomain.getCompanyName(), typeName);
        CostTypeDomain typeDomain = new CostTypeDomain();
        if (null == type || null == type.getTypeNo()) {
            typeDomain.setTypeNo(createTypeNo());
            typeDomain.setTypeName(typeName);
            typeDomain.setSubjectCode(row.getCell(2).getStringCellValue());
            typeDomain.setCompanyName(companyDomain.getCompanyName());
            typeDomain.setCompanyNo(companyDomain.getCompanyNo());

            typeDomain = setCostForm(typeDomain, row, s, r);
            // TODO try 重复的 typeNo
            Integer insert = costTypeDao.insert(typeDomain);
        }
        return typeDomain;
    }

    private CostTypeDomain setCostForm(CostTypeDomain typeDomain, Row row, Integer s, Integer r) {

        // 费用类型 第 4 列
        if (null != row.getCell(4) && !row.getCell(4).getStringCellValue().isEmpty()) {
            String costFormStr = row.getCell(4).getStringCellValue();
            if ("付款".equals(costFormStr)) {
                typeDomain.setCostForm(1);
            } else if ("收款".equals(costFormStr)) {
                typeDomain.setCostForm(2);
            } else {
                typeDomain.setCostForm(3);
                if ("借支".equals(costFormStr)) {
                    typeDomain.setIsLend(1);
                } else if ("借还".equals(costFormStr)) {
                    typeDomain.setIsLend(2);
                } else {
                    throw new RuntimeException("sheet" + (s + 1) + "  " + "第 " + (r) + " 行费用类型不明确");
                }
            }
        } else {
            throw new RuntimeException("sheet" + (s + 1) + "  " + "第 " + (r) + " 行费用类型不明确");
        }
        return typeDomain;
    }

    private String createTypeNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddhhmmss");
        Random random = new Random();
        String typeNo = "CTN" + sdf.format(new Date()) + random.nextInt(9);
        CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNo(typeNo);
        while (null != costTypeDomain) {
            typeNo = "CTN" + sdf.format(new Date()) + random.nextInt(9);
            costTypeDomain = costTypeDao.selectByTypeNo(typeNo);
        }
        return typeNo;
    }

    private Integer doInsert(CostTypeKindDomain costTypeKindDomain) {
        // 获取 type 信息
        CostTypeDomain costTypeDomain = costTypeDao.selectByTypeNo(costTypeKindDomain.getTypeNo());
        BeanUtils.copyProperties(costTypeDomain, costTypeKindDomain);
        // 补充剩余属性,执行 insert
        costTypeKindDomain.setId(null);
        costTypeKindDomain.setKindNo(createKindNo());
        costTypeKindDomain.setCostTypeStatus(1);
        costTypeKindDomain.setSubjectCode(costTypeDomain.getSubjectCode());
        Integer result = costTypeKindDao.insert(costTypeKindDomain);
        return result;
    }

    /**
     * 生成唯一的费用种类编号
     *
     * @return
     */
    private String createKindNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        Random random = new Random();
        String costTypeKindNo = "CTK" + sdf.format(new Date()) + random.nextInt(9);
        CostTypeKindDomain costTypeKindDomain = costTypeKindDao.selectByKindNo(costTypeKindNo);
        while (null != costTypeKindDomain && null != costTypeKindDomain.getKindName()) {
            costTypeKindNo = "CTK" + sdf.format(new Date()) + random.nextInt(9);
            costTypeKindDomain = costTypeKindDao.selectByKindNo(costTypeKindNo);
        }
        return costTypeKindNo;
    }

    private List<CostTypeKindDto> getDtoList(List<CostTypeKindDomain> list) {
        List<CostTypeKindDto> costTypeKindDtoList = new ArrayList<>();
        if (null != list && list.size() >= 1) {
            CostTypeKindDto costTypeKindDto;
            for (CostTypeKindDomain costTypeKindDomain : list) {
                costTypeKindDto = new CostTypeKindDto();
                BeanUtils.copyProperties(costTypeKindDomain, costTypeKindDto);
                costTypeKindDto.setCostTypeStatusDto(getCostTypeStatus("cost_type_status", costTypeKindDto.getCostTypeStatus()));
                costTypeKindDtoList.add(costTypeKindDto);
            }
        }
        return costTypeKindDtoList;
    }

    private String getCostTypeStatus(String statusname, Integer statuskey) {
        return statusMapper.getStatusValue(statusname, statuskey);
    }

    @Override
    public LogisticsSupplierBankDomain getLogisticsBank(String subSupplierName) {
        return logisticsSupplierBankDao.selectBySubSupplier(subSupplierName);
    }
}
