package com.blt.other.module.cost.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.blt.other.module.database.model.UserCostFinansysDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface UserCostFinansysDao extends BaseMapper<UserCostFinansysDomain> {

//    Integer insert(UserCostFinansysDomain userCostFinansysDomain);

    UserCostFinansysDomain selectByNo(String userCostFinansysNo);

    List<UserCostFinansysDomain> selectByUsercode(String usercode);

    UserCostFinansysDomain selectByDetail(UserCostFinansysDomain userCostFinansysDomain);

    List<UserCostFinansysDomain> selectAll();

    /**
     * 从财务系统同步财务账号信息时查询是否已存在
     *
     * @param bankName
     * @param bankCard
     * @param bankCardUser
     * @param bankCompany
     * @return
     */
    UserCostFinansysDomain selectByBankInfo(@Param("bankName") String bankName,
                                            @Param("bankCard") String bankCard,
                                            @Param("bankCardUser") String bankCardUser,
                                            @Param("bankCompany") String bankCompany);

    Integer updateBySyncId(UserCostFinansysDomain userCostFinansysDomain);

    List<UserCostFinansysDomain> selectByUserid(@Param("userid") Integer userid);
}
