package com.blt.other.module.auth.dao;

import com.blt.other.module.database.model.UserDomain;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface UserDao {
    UserDomain select(String userCode);

    List<UserDomain> selectUsers();

    Integer update(UserDomain userDomain);

    Integer insertUser(UserDomain userDomain);

    Integer insertUserNew(UserDomain userDomain);

    Integer insert(UserDomain userDomain);

    UserDomain selectByuserid(Integer userid);

    UserDomain findByUsername(String username);

    List<UserDomain> selectByKey(String key);

    List<UserDomain> selectAdmins();

    List<UserDomain> selectFinansys();

    List<UserDomain> selectSupAdmins();

    Integer delete(int parseInt);

    /**
     * <p>
     * 根据百伦一级部门id查找费用系统用户列表
     * </p>
     *
     * @param primaryDepartmentId 一级部门id
     * @return 费用系统用户列表
     */
    List<UserDomain> getByPrimaryDepartmentId(Integer primaryDepartmentId);

    /**
     * <p>
     * 根据百伦公司id查找费用系统用户列表
     * </p>
     *
     * @param companyId 公司id
     * @return 费用系统用户列表
     */
    List<UserDomain> getByCompanyId(Integer companyId);
}
