package com.blt.other.other_purchasing.utils;

import com.blt.other.other_database.model.BuyDomain;
import com.blt.other.other_database.model.CostDomain;
import com.blt.other.other_purchasing.service.BuyService;

import java.text.NumberFormat;

public class BuyUtils {

    /**
     * 生成唯一、易记的采购单号
     * @param buyService
     * @return
     */
    public static String createBuyNo(BuyService buyService) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(6);
        nf.setMinimumIntegerDigits(6);

        String result = "";
        BuyDomain lastBuy = buyService.getLastBuy();
        if (null == lastBuy){
            return "BU000000";
        }else {
            String buyno = lastBuy.getBuyno();
            if (buyno != null && buyno.contains("-")){
                buyno = buyno.split("-")[0];
            }
            if (null != buyno && (buyno.startsWith("BU"))) {
                String[] os = buyno.split("BU");
                result = nf.format(Integer.parseInt(os[1]) + 1);
            }
            if (null != buyno && !buyno.startsWith("BU")){
                return "BU000000";
            }
            if (null == buyno){
                return "BU000000";
            }
        }
        return "BU"+result;
    }
}
