package com.blt.other.other_cost.service;

import com.blt.other.other_cost.dto.LogisticsCostDto;
import com.blt.other.other_cost.dto.ManageCostDto;
import com.blt.other.other_database.model.CostDomain;

import java.util.Date;
import java.util.List;

public interface CostApiService {
    /**
     * 接收物流单，自动生成付款费用单到财务审核
     * @param logisticsCostDto
     */
    String generateLogisticsCost(LogisticsCostDto logisticsCostDto) throws Exception;

    /**
     * 查询管理成本费用列表
     * @param startDateStr
     * @param endDateStr
     * @param feeSuperType
     * @param companyValue
     * @param companyName
     * @param departmentName
     * @param createUserId
     * @param payUserId
     * @return
     * @throws Exception
     */
    List<ManageCostDto> getMangeCostList(String startDateStr, String endDateStr, String feeSuperType, String feeSubType, Integer companyValue, String companyName, String departmentName,Integer createUserId, Integer payUserId) throws Exception;

    /**
     * 查询资产负债表相关费用单
     * @param startDate
     * @param endDate
     * @return
     */
    List<CostDomain> getBalanceSheetCost(Date startDate, Date endDate);

    /**
     * 查询原来传输到数据中心时为待支付状态 变成 已支付状态后的费用单
     * @param costNoList
     * @return
     */
    List<CostDomain> getNoPayCost(List<String> costNoList);


    CostDomain getCostDetails(String costNo);
}
