package com.blt.other.module.auth.service.impl;

import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.module.auth.service.GetDeparmentListService;
import com.blt.other.module.auth.vo.DepartmentMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.List;

@Service
public class GetDeparmentListServiceImpl implements GetDeparmentListService {

    Logger logger = LoggerFactory.getLogger(GetDeparmentListServiceImpl.class);



    @Resource
    CostUrlProperties costUrlProperties;
    @Override
    public List<DepartmentMsg> getList() {
        RestTemplate restTemplate = new RestTemplate();
        String response = restTemplate.getForEntity(costUrlProperties.getDepartmentListApi, String.class).getBody();
        return JsonUtilByFsJson.jsonToList(response, DepartmentMsg.class);
    }

    @Override
    public DepartmentMsg getDepartment(String debarmentName) {
        List<DepartmentMsg> list = getList();
        if (null != list && list.size() >= 1) {
            for (DepartmentMsg departmentMsg : list) {
                if (null != debarmentName && (debarmentName.toLowerCase()).equals((departmentMsg.getName()).toLowerCase())) {
                    return departmentMsg;
                }
            }
        }
        return null;
    }


}
