package com.blt.other.other_auth.controller;

import com.blt.other.other_auth.service.GetDeparmentListService;
import com.blt.other.other_auth.vo.DeparmentMsg;
import com.blt.other.other_commons.utils.AxiosUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("/deparment")
public class DeparmentController {

    @Autowired
    private GetDeparmentListService getDeparmentListService;

    @PostMapping("/getDeparmentByName")
    public DeparmentMsg getDeparmentByName(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String deparmentName = request.getParameter("deparmentName");
        DeparmentMsg deparment = getDeparmentListService.getDeparment(deparmentName);
        return deparment;
    }
}
