package com.blt.other.other_commons.utils;

import com.blt.other.other_purchasing.vo.CompanyVo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class CompanyUtil {

    private static Logger logger = LoggerFactory.getLogger(CompanyUtil.class);

    public static List<CompanyVo> getCompanyList(String postCompanyListApi) {

        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> params= new LinkedMultiValueMap<String, String>();
        HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<MultiValueMap<String, String>>(params, headers);
        ResponseEntity<String> response = restTemplate.exchange(postCompanyListApi, HttpMethod.POST, requestEntity, String.class);

        ObjectMapper mapper = new ObjectMapper();
        String strBody = null;
        if (response != null && response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
        }

        JavaType javaType = mapper.getTypeFactory().constructParametricType(Collection.class, CompanyVo.class);
        List<CompanyVo> companyVos = null;
        try {
            strBody = strBody.toLowerCase();
            strBody = strBody.substring(strBody.indexOf("["),strBody.lastIndexOf("}"));
            companyVos = (List<CompanyVo>) mapper.readValue(strBody, javaType);
        } catch (IOException e) {
            logger.error("公司主体类型转换失败 = = = = = = = = = = = = = = = = = = = = =");
            e.printStackTrace();
            return null;
        }
        return companyVos;
    }
}
