package com.blt.other.module.cost.service.impl.cost;

import com.bailuntec.api.bailuntec.cw.CwApi;
import com.bailuntec.api.bailuntec.cw.request.ApplyMoneyDetail;
import com.bailuntec.api.bailuntec.cw.request.PostApplyReq;
import com.bailuntec.api.bailuntec.cw.response.CwResult;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.JsonUtilByFsJson;
import com.bailuntec.common.JsonUtilByJackson;
import com.blt.other.common.config.property.CostUrlProperties;
import com.blt.other.common.exception.RpcException;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.vo.TofinanceVo;
import com.blt.other.database.model.CostTofinanceDomain;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:35 上午
 */
@Slf4j
@Service
public class ReceiptCostServiceImpl extends AbstractCostService implements CostService {

    @Autowired
    CwApi cwApi;
    @Resource
    CostUrlProperties costUrlProperties;

    @Override
    public void toFinancial(CostDomain cost) {


        PostApplyReq req = cost.buildPostApplyReq();
        // 审核回调地址(ApplyCallbackUrl)不可为空；
        req.setApplyCallbackUrl(costUrlProperties.costApplyCallbackUrlPost);
        // 出纳回调地址(CashierCallbackUrl)不可为空；
        req.setCashierCallbackUrl(costUrlProperties.costCashierCallbackUrlPost);
        req.setApplyType("" + 2);

        List<ApplyMoneyDetail> applyMoneyDetailList = new ArrayList<>();
        ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();
        applyMoneyDetail.setName("借支单收款");
        applyMoneyDetail.setMoney(cost.getAmount());
        //todo
        applyMoneyDetail.setMoneyRmb(cost.getAmount());
        applyMoneyDetail.setRemark("");

        applyMoneyDetailList.add(applyMoneyDetail);
        // 出纳申请金额明细(MoneyDetail)不可为空；
        req.setMoneyDetail(applyMoneyDetailList);

        log.info(JsonUtilByFsJson.beanToJson(req));
        CwResult<String> cwResult = cwApi.postApply(req);
        log.info(JsonUtilByFsJson.beanToJson(cwResult));
        if (!cwResult.getSuccess()) {
            throw new RpcException(cwResult.getMessage());
        }
        TofinanceVo tofinanceVo = JsonUtilByJackson.readValue(cwResult.getData().replaceAll("/^['|\"](.*)['|\"]$/", ""), TofinanceVo.class);

        //保存财务系统调用信息
        CostTofinanceDomain costTofinanceDomain = new CostTofinanceDomain();
        BeanUtils.copyProperties(tofinanceVo, costTofinanceDomain);
        costTofinanceDomain.setCostNo(cost.getCostNo().toUpperCase());
        costTofinanceDomain.setCode(costTofinanceDomain.getCode().toUpperCase());
        costTofinanceService.saveCostToFinanceMsg(costTofinanceDomain);
    }
}
