package com.blt.other.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.common.base.SysUser;
import com.blt.other.common.exception.BizRuntimeException;
import lombok.extern.slf4j.Slf4j;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

import java.util.HashMap;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/18 11:47 上午
 */
@Slf4j
public class JwtUtil {

    /**
     * 前缀
     */
    public static final String TOKEN_PREFIX = "Bearer ";
    private static final String PUBLIC_KEY = "{\"kty\":\"RSA\",\"use\":\"sig\",\"kid\":\"0a968baa62e99029a973415887029fbd\",\"e\":\"AQAB\",\"n\":\"1hr9F7WGP6jpixp8kxN2E0BUB23EYiR0jSfdZQsN0ljnZfyqORK6fETVMDxDHB-ueekqieKh7UYJO3Cc3ecC2WCP7Z0KDsGcQBFJd0a9_BBktYv1rDnteJF3v43XkM1gi6gBEtXUb_l-mfpp14His6HtGH8W0v0klBOQ8UsBHDZvOHr2ns_qWPn0i6N86EUe1W47dGSy7fbms3nYQEncNFpnug6x39fJyFxpKjHS_63f2r3QRdf8UlHbjoVsHjg9sJ7pznrxDIIK8heRqH4JiutV8LhagPBVSm8UVHNwdi5IfjmVpYDirBrZDJZq7FwhyZE7ua29a3wP2I08qS9yJw\",\"alg\":\"RS256\"}";

    /**
     * 功能描述: 解密Bailun Sso Token
     *
     * @param token jwtToken
     */
    public static SysUser validateToken(String token) {
        try {
            JwtConsumer consumer = new JwtConsumerBuilder()
                    .setExpectedAudience("http://localhost:5001/resources", "bailunApi")
                    .setVerificationKey(new RsaJsonWebKey(JSON.parseObject(PUBLIC_KEY, new TypeReference<HashMap<String, Object>>() {
                    })).getPublicKey())
                    .build();
            JwtClaims claims = consumer.processToClaims(token.replaceAll(TOKEN_PREFIX, ""));
            if (claims != null) {
                log.debug("认证通过：user:{}", claims.toJson());

                return JsonUtilByFsJson.jsonToBean(claims.toJson(), SysUser.class);
            }
            throw new BizRuntimeException("400", "登陆失效");
        } catch (Exception e) {
            e.printStackTrace();
            throw new BizRuntimeException("400", "登陆失效");
        }
    }


}
