package com.blt.other.module.cost.service;

import com.bailuntec.cost.api.dto.LogisticsFinansysDto;
import com.bailuntec.cost.api.dto.SubLogisticsFinansysDto;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.database.model.CostPlanDomain;
import com.blt.other.module.database.model.UserCostFinansysDomain;

import java.util.List;

public interface UserCostFinansysService {

    /**
     * 保存用户填写的财务信息
     *
     * @param userCostFinansysDomain 财务信息
     * @return res
     */
    Integer saveFinansysRecord(UserCostFinansysDomain userCostFinansysDomain);

    /**
     * <p>
     * 根据费用单信息构建财务信息
     * </p>
     *
     * @param planDomain 费用单计划
     * @return 财务信息
     */
    UserCostFinansysDomain createFinansyRecordByCostPlanDomain(CostPlanDomain planDomain);

    UserCostFinansysDomain createFinansyRecordByCostDomain(CostDomain costDomain);

    UserCostFinansysDomain getByUserCostFinansysNo(String userCostFinansysNo);

    UserCostFinansysDomain getByUserCostFinansysDetail(UserCostFinansysDomain userCostFinansysDomain);

    List<UserCostFinansysDomain> getAllFinansysRecord();

    String syncUserFinansys();

    List<UserCostFinansysDomain> getByUserid(int parseInt);

    /**
     * 获取所有一级物流供应商财务信息
     *
     * @return
     */
    List<LogisticsFinansysDto> getAllLogisticsFinansys();

    /**
     * 获取所有二级物流供应商财务信息
     *
     * @return
     */
    List<SubLogisticsFinansysDto> getAllSubLogisticsFinansys();

}
