package com.blt.other.module.database.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.blt.other.module.auth.model.CostReviewer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@TableName("cost_company")
@Data
public class CostCompanyDomain {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("费用系统自编no")
    private String companyNo;

    @ApiModelProperty("财务主体名")
    private String companyName;

    private Integer value;

    private LocalDateTime lastUpdateTime;
    private LocalDateTime createTime;
    private Integer createUserId;

    private Integer updateUserId;
    private String updateUserName;

    @ApiModelProperty("最终审核人")
    @TableField(exist = false)
    private CostReviewer finalReviewer;

    @ApiModelProperty("财务审核人")
    @TableField(exist = false)
    private List<CostReviewer> financialReviewer;


}
