package com.blt.other.common.job;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostLogDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.database.model.CostLogDomain;
import com.blt.other.module.database.model.UserDomain;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public class CostStatusSyncJob extends QuartzJobBean {

    private static Logger logger = LoggerFactory.getLogger(CostCompanySyncJob.class);

    @Autowired
    private CostService costService;

    @Autowired
    private CostLogDao costLogDao;

    @Autowired
    private CostDao costDao;

    @Autowired
    private UserDao userDao;

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        logger.info("系统自动作废驳回费用单");
        List<CostDomain> costDomainList = costDao.selectList(new LambdaQueryWrapper<CostDomain>()
                .eq(CostDomain::getCostStatus, CostDomain.STATUS_REJECT)
                .eq(CostDomain::getRejectType, 1)
                .lt(CostDomain::getRejectTime, LocalDateTime.now().minusDays(1)));

        costDomainList.forEach(costDomain -> {
            costDomain.setCostStatus(CostDomain.STATUS_DELETE);
            int result = costDao.updateById(costDomain);
            if (result > 0) {
                CostLogDomain costLog = new CostLogDomain();
                costLog.setCostNo(costDomain.getCostNo());
                costLog.setUpdateTime(new Date());
                UserDomain user = userDao.selectByuserid(2493);
                costLog.setUpdateUsercode(user.getUsercode());
                costLog.setUpdateUserid(2493);
                costLog.setUpdateUsername(user.getUsername());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                costLog.setUpdateNote(sdf.format(costLog.getUpdateTime()) + "  过期财务驳回单系统自动作废  更新人：" + user.getUsername());
                costLogDao.insert(costLog);
            }
        });

    }
}
