package com.blt.other.module.cost.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.blt.other.database.model.CostCompanyDomain;
import com.blt.other.module.sys.dto.request.CompanyReviewerListReq;
import com.blt.other.module.sys.dto.request.CostReviewerExportReq;
import com.blt.other.module.sys.dto.response.CostReviewerExportItem;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostCompanyDao extends BaseMapper<CostCompanyDomain> {

    /**
     * 添加主体
     *
     * @param costCompanyDomain
     * @return
     */
    Integer insertCompany(CostCompanyDomain costCompanyDomain);

    /**
     * 通过主体名称获取主体
     *
     * @param costCompanyDomain
     * @return
     */
    List<CostCompanyDomain> selectByNameOrValue(CostCompanyDomain costCompanyDomain);

    /**
     * 通过 companyNo 获取主体
     *
     * @param no
     * @return
     */
    CostCompanyDomain selectByNo(String no);

    /**
     * 通过 companyNo 修改主体信息
     *
     * @param costCompanyDomain
     * @return
     */
    Integer update(CostCompanyDomain costCompanyDomain);

    /**
     * 获取所有主体列表
     *
     * @return
     */
    List<CostCompanyDomain> selectAll();

    List<CostCompanyDomain> getAllCompanyAuthority();

    /**
     * 根据主体名获取主体
     *
     * @param companyName
     * @return
     */
    CostCompanyDomain selectByName(String companyName);

    /**
     * <p>
     * 查询财务审核人和最终审核人配置
     * </p>
     *
     * @param page 分页参数
     * @param req  查询参数
     * @return
     */
    IPage<CostCompanyDomain> reviewerPage(@Param("page") IPage<CostCompanyDomain> page, @Param("req") CompanyReviewerListReq req);

    //导出
    List<CostReviewerExportItem> costReviewerExportItemList(@Param("req") CostReviewerExportReq req);
}
