package com.blt.other.module.cost.controller;

import com.bailuntec.cost.api.dto.CostDto;
import com.bailuntec.cost.api.response.CostResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.blt.other.module.cost.dto.request.AppCheckCostListReq;
import com.blt.other.module.cost.dto.request.AppCostListReq;
import com.blt.other.module.cost.dto.request.AppCostPassReq;
import com.blt.other.module.cost.dto.request.AppCostRejectReq;
import com.blt.other.module.cost.service.AppCostService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/14 1:11 下午
 */
@Api(tags = "小程序接口")
@RestController
@RequestMapping("/app/cost")
public class MiniAppCostController {

    @Resource
    private AppCostService appCostService;

    @ApiOperation("待审核列表")
    @PostMapping("/appCheckCostList")
    public CostResult<Page<CostDto>> appCheckCostList(@RequestBody AppCheckCostListReq req) {
        Page<CostDto> page = appCostService.appCheckCostList(req);
        return CostResult.success(page);
    }

    @ApiOperation("小程序审核通过")
    @PostMapping("/appCostPass")
    public CostResult<Void> appCostPass(@RequestBody AppCostPassReq req) {
        appCostService.appCostPass(req);
        return CostResult.success();
    }

    @ApiOperation("小程序审核拒绝")
    @PostMapping("/appCostReject")
    public CostResult<Void> appCostReject(@RequestBody AppCostRejectReq req) {
        appCostService.appCostReject(req);
        return CostResult.success();
    }

    @ApiOperation("费用列表")
    @PostMapping("/appCostList")
    public CostResult<Page<CostDto>> appCostList(@RequestBody AppCostListReq req) {
        Page<CostDto> page = appCostService.appCostList(req);
        return CostResult.success(page);
    }
}
