package com.blt.other.other_sku.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_database.model.SkuKindDomain;
import com.blt.other.other_sku.service.SkuKindService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/sku/kind")
public class SkuKindController {

    @Autowired
    private SkuKindService skuKindService;

    @PostMapping("/add/save")
    public Map<String,Object> save(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String skuKindName = request.getParameter("skuKindName");
        String skuTypeNo = request.getParameter("skuTypeNo");
        // 判断是否已存在相同 skuKindName skuTypeNo 的记录
        List<SkuKindDomain> listBySkuKindNameAndSkuTypeNo = skuKindService.getListBySkuKindNameAndSkuTypeNo(skuKindName, skuTypeNo);
        if (null != listBySkuKindNameAndSkuTypeNo && listBySkuKindNameAndSkuTypeNo.size() >= 1){
            result.put("success",false);
            result.put("msg",skuKindName+" 已存在");
            return result;
        }
        String createUserIdstr = request.getParameter("createUserId");
        Integer createUserId = null;
        try {
            createUserId = Integer.parseInt(createUserIdstr);
        }catch (NumberFormatException e){
            result.put("success",false);
            result.put("msg","请登陆");
            return result;
        }
        SkuKindDomain skuKindDomain = new SkuKindDomain();
        skuKindDomain.setSkuKindName(skuKindName);
        skuKindDomain.setSkuTypeNo(skuTypeNo);
        skuKindDomain.setCreateUserId(createUserId);
        skuKindDomain.setCreateTime(new Date());

        Integer integer = skuKindService.saveSkuKind(skuKindDomain);

        result.put("success",true);
        result.put("skuType",skuKindDomain);
        return result;
    }

    @GetMapping("getSkuKindList")
    public Map<String,Object> getSkuKindList(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        List<SkuKindDomain> skuKindList = skuKindService.getSkuKindList();

        result.put("success",true);
        result.put("skuKinds",skuKindList);

        return result;
    }

    @GetMapping("getSkuKindListByTypeNo")
    public Map<String,Object> getSkuKindListByTypeNo(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String skuTypeNo = request.getParameter("skuTypeNo");
        List<SkuKindDomain> skuKindList = skuKindService.getSkuKindListByTypeNo(skuTypeNo);
        result.put("success",true);
        result.put("skuKinds",skuKindList);

        return result;
    }

    @GetMapping("getSkuKindByKindNo")
    public Map<String,Object> getSkuKindByKindNo(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();

        String skuKindNo = request.getParameter("skuKindNo");
        SkuKindDomain bySkuKindNo = skuKindService.getBySkuKindNo(skuKindNo);
        result.put("success",true);
        result.put("skuKind",bySkuKindNo);

        return result;
    }

}
