package com.blt.other.other_entrepot.controller;

import com.blt.other.other_database.model.StorageDomain;
import com.blt.other.other_entrepot.dto.StorageDto;
import com.blt.other.other_entrepot.service.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("storage/detail/")
public class StorageDetailController {

    @Autowired
    private StorageService storageService;

    /**
     * 获取入库单详情
     * @param request
     * @param response
     * @return
     */
    @GetMapping("getStorageByStorageno")
    public Map<String,Object> getStorageByStorageno(HttpServletRequest request, HttpServletResponse response){
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials","true");
        String storageno = request.getParameter("storageno");
        StorageDto storageByStorageno = storageService.getStorageByStorageno(storageno);
        Map<String,Object> result = new HashMap<>();
        result.put("storage",storageByStorageno);
        return result;
    }

    /**
     * 修改发货信息
     * @param request
     * @param response
     * @return
     */
    @PostMapping("postSave")
    public Map<String,Object> postSave(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials", "true");
        String storageno = request.getParameter("storageno");
        String sendstatus = request.getParameter("sendstatus");

        StorageDomain storageDomain = new StorageDomain();
        storageDomain.setStorageno(storageno);
        storageDomain.setSendstatus(Integer.parseInt(sendstatus));
        Integer update = storageService.update(storageDomain);

        Map<String,Object> result = new HashMap<>();
        if (null != update && update >= 1){
            result.put("msg","发货信息已修改");
            StorageDto storageByStorageno = storageService.getStorageByStorageno(storageno);
            result.put("storage",storageByStorageno);
            return result;
        }
        result.put("msg","发货信息修改失败，请重试");
        return result;
    }
}
