package com.blt.other.module.cost.service.impl.cost;

import com.bailuntec.api.bailuntec.cw.CwApi;
import com.bailuntec.api.bailuntec.cw.request.ApplyMoneyDetail;
import com.bailuntec.api.bailuntec.cw.request.PostApplyReq;
import com.bailuntec.api.bailuntec.cw.response.CwResult;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.JsonUtilByJackson;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.common.util.CurUtils;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.vo.TofinanceVo;
import com.blt.other.module.database.model.CostCashiercallbackDomain;
import com.blt.other.module.database.model.CostTofinanceDomain;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 11:35 上午
 */
@Slf4j
@Service
public class Lend2PayCostServiceImpl extends AbstractCostService implements CostService {
    @Autowired
    CwApi cwApi;

    @Override
    public void toFinancial(CostDomain cost) {
        if (cost.getLendBalance().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BizRuntimeException("invalid amount");
        }

        PostApplyReq req = super.buildPostApplyReq(cost);
        // 审核回调地址(ApplyCallbackUrl)不可为空；
        req.setApplyCallbackUrl(costApplyCallbackUrlPost);
        // 出纳回调地址(CashierCallbackUrl)不可为空；
        req.setApplyCallbackUrl(costCashierCallbackUrlPost);
        req.setApplyType("" + 1);

        List<ApplyMoneyDetail> applyMoneyDetailList = new ArrayList<>();
        ApplyMoneyDetail applyMoneyDetail = new ApplyMoneyDetail();
        applyMoneyDetail.setName("借支单付款");
        applyMoneyDetail.setMoney(cost.getAmount());
        //todo
        applyMoneyDetail.setMoneyRmb(cost.getAmount());
        applyMoneyDetail.setRemark("");

        applyMoneyDetailList.add(applyMoneyDetail);
        // 出纳申请金额明细(MoneyDetail)不可为空；
        req.setMoneyDetail(applyMoneyDetailList);


        CwResult<String> cwResult = cwApi.postApply(req);

        TofinanceVo tofinanceVo = JsonUtilByJackson.readValue(cwResult.getData().replaceAll("/^['|\"](.*)['|\"]$/", ""), TofinanceVo.class);

        //保存财务系统调用信息
        CostTofinanceDomain costTofinanceDomain = new CostTofinanceDomain();
        BeanUtils.copyProperties(costTofinanceDomain, tofinanceVo);
        costTofinanceDomain.setCostNo(cost.getCostNo().toUpperCase());
        costTofinanceDomain.setCode(costTofinanceDomain.getCode().toUpperCase());
        costTofinanceService.saveCostTofinanceMsg(costTofinanceDomain);
    }

    @Override
    void cashierCallbackPass(CostCashiercallbackDomain costCashiercallbackDomain) {
        //  付款成功，更改借还单信息，否则返回失败
        CostDomain costDomainByNo = this.getCostByCostNo(costCashiercallbackDomain.getCostNo());
        String sonNo = costDomainByNo.getCostNo().toUpperCase();
        changeStatus(costCashiercallbackDomain.getCostNo(), 4, costDomainByNo.getLendStatus(), costCashiercallbackDomain.getPayuserid());
        if (sonNo.contains("S")) {
            CostDomain supCostDomain = this.getCostByCostNo(costDomainByNo.getSupCostNo());
            if (null == supCostDomain.getHadPay()) supCostDomain.setHadPay(new BigDecimal(0));
            if (null == supCostDomain.getCompensate()) supCostDomain.setCompensate(new BigDecimal(0));
//                    supCostDomain.setCompensate(supCostDomain.getCompensate().add(costCashiercallbackDomain.getPayamount()));
            supCostDomain.setCompensate(supCostDomain.getCompensate().subtract(costCashiercallbackDomain.getPayamount()));
//                    supCostDomain.setHadPay(supCostDomain.getHadPay().add(costCashiercallbackDomain.getPayamount()));
            // 借还单在出纳完成收付款后，不用直接获取返回的金额（使用费用系统中记录的提交金额，出纳系统结算的实时汇率和费用系统不一定一致）
            supCostDomain.setHadPay(supCostDomain.getHadPay().add(costDomainByNo.getAmount()));
//                    int i = supCostDomain.getAmount().compareTo(supCostDomain.getHadPay().subtract(supCostDomain.getCompensate()));
            BigDecimal zero = new BigDecimal(0);
            if (supCostDomain.getCompensate().compareTo(zero) == 0) {
                supCostDomain.setLendStatus(4);
                // 已补差额，但是仍有金额未到账
                BigDecimal allPayAmount = supCostDomain.getAmount().add(costCashiercallbackDomain.getPayamount());
                int i = allPayAmount.compareTo(supCostDomain.getHadPay());
                if (0 < i) {
                    supCostDomain.setLendStatus(2);
                }
            }

            if (supCostDomain.getCompensate().compareTo(zero) == 1) {
                supCostDomain.setLendStatus(3);
            }
            this.updateCost(supCostDomain);
        }
        if (!sonNo.contains("S") && null != costDomainByNo.getSupCostNo()) {
            CostDomain supCostDomain = this.getCostByCostNo(costDomainByNo.getSupCostNo());
            if (null == supCostDomain.getHadPay()) {
                supCostDomain.setHadPay(new BigDecimal(0));
            }
//                    supCostDomain.setHadPay(supCostDomain.getHadPay().add(costCashiercallbackDomain.getCashierpaymoney()));
            // 借还单在出纳完成收付款后，不用直接获取返回的金额（使用费用系统中记录的提交金额，出纳系统结算的实时汇率和费用系统不一定一致）
            supCostDomain.setHadPay(supCostDomain.getHadPay().add(costDomainByNo.getAmount()));
            if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) == 0) {
                supCostDomain.setLendStatus(4);
            }
            if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) == -1) {
                supCostDomain.setLendStatus(2);
            }
            if (supCostDomain.getHadPay().compareTo(supCostDomain.getAmount()) == 1) {
                supCostDomain.setLendStatus(3);
                supCostDomain.setCompensate(supCostDomain.getHadPay().subtract(supCostDomain.getAmount()));
            }
            this.updateCost(supCostDomain);
        }
        costLogService.save(costCashiercallbackDomain.getCostNo(), costCashiercallbackDomain.getPayuserid(), "出纳收/付款成功：" + costCashiercallbackDomain.getPaynote());

    }

    private void changeStatus(String costNo, Integer costStatus, Integer lendStatus, Integer updateUserId) {

        Date now = new Date();
        CostDomain costDomain = this.getCostByCostNo(costNo);
        costDomain.setCostStatus(costStatus);
        costDomain.setCostNo(costNo);
        costDomain.setLendStatus(lendStatus);
        costDomain.setPayUserId(updateUserId);
        costDomain.setPayTime(now);
        BigDecimal toRmbRate = CurUtils.getCur(costDomain.getDic(), "CNY", getExchangeRateApi);
        costDomain.setToRmbRate(toRmbRate);
        costDomain.setAmountRmb(costDomain.getAmount().multiply(toRmbRate).setScale(2, BigDecimal.ROUND_HALF_UP));
        costDomain.setAuditTime(now);
        this.updateCost(costDomain);
    }

}
