package com.blt.other.module.cost.service.impl;

import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.dao.CostListSearchDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostListSearchService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.vo.CostListSearchKeysVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class CostListSearchServiceImpl implements CostListSearchService {

    @Autowired
    private CostListSearchDao costListSearchDao;
    @Autowired
    private CostService costService;
    @Autowired
    CostDao costDao;

    @Override
    public PageInfo<CostDto> searchByKey(String key, int pageNum, int pageSize) {

        PageHelper.startPage(pageNum, pageSize);
        List<CostDto> costDtos = costListSearchDao.selectByKey(Lists.newArrayList(key.split(","))
                .stream()
                .filter(Objects::nonNull)
                .collect(Collectors.toList()))
                .stream()
                .map(CostDomain::castToDto)
                .collect(Collectors.toList());
        return new PageInfo<>(costDtos);
    }

    @Override
    public PageInfo<CostDto> searchByKeys(CostListSearchKeysVo searchKeysVo) {

        PageHelper.startPage(searchKeysVo.getParams().getPageNum(), searchKeysVo.getParams().getPageSize());
        List<CostDomain> domains = costListSearchDao.selectByKeys(searchKeysVo);
        CostDomain supCost = costDao.selectByCostNo(searchKeysVo.getParams().getKeys().getLinkCost());
        domains.add(supCost);
        return new PageInfo<>(domains.stream().map(CostDomain::castToDto).collect(Collectors.toList()));
    }

    @Override
    public List<CostDomain> getLinkCost() {
        return costListSearchDao.selectLinkList();
    }
}
