package com.blt.other.module.cost.service;

import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.module.cost.dto.CostApiDto;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.vo.CostListSearchKeysVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

public interface CostListSearchService {

    /**
     * 通过关键字模糊查询
     *
     * @param key key
     * @return res
     */
    PageInfo<CostDto> searchByKey(String key, int pageNum, int pageSize);

    /**
     * 多条件筛选
     *
     * @param searchKeysVo param
     * @return res
     */
    PageInfo<CostDto> searchByKeys(CostListSearchKeysVo searchKeysVo);

    /**
     * 获取借支单列表
     *
     * @return 借支单列表
     */
    List<CostDomain> getLinkCost();

}
