//package com.blt.other.module.cost.controller.cost;
//
//import com.blt.other.common.util.AxiosUtil;
//import com.blt.other.common.util.MyMapperUtil;
//import com.blt.other.module.cost.service.CostCheckSearchService;
//import com.blt.other.module.cost.vo.CostCheckSearchKeysVo;
//import com.blt.other.module.cost.model.CostDomain;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.web.bind.annotation.GetMapping;
//import org.springframework.web.bind.annotation.PostMapping;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RestController;
//
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//import java.util.Enumeration;
//import java.util.List;
//import java.util.Map;
//
//@RestController
//@RequestMapping("cost/check/search")
//public class CostCheckSearchController {
//    private Logger logger = LoggerFactory.getLogger(CostCheckSearchController.class);
//
//    @Autowired
//    private CostCheckSearchService costCheckSearchService;
//
//    /**
//     * 获取费用系统 财务审核列表
//     * @param request
//     * @param response
//     * @return
//     */
//    @GetMapping("getCostCheckList")
//    public Map<String,Object> getCostCheckList(HttpServletRequest request, HttpServletResponse response){
//        AxiosUtil.setCors(response,request);
//
//        String pageNumStr = request.getParameter("pageNum");
//        Integer pageNum = null;
//        if (null != pageNumStr && !pageNumStr.isEmpty()){
//            pageNum = Integer.parseInt(pageNumStr);
//        }
//        String pageSizeStr = request.getParameter("pageSize");
//        Integer pageSize = null;
//        if (null != pageSizeStr && !pageSizeStr.isEmpty()){
//            pageSize = Integer.parseInt(pageSizeStr);
//        }
//
//        Integer userId = Integer.valueOf(request.getParameter("userId"));
//        String authority = costCheckSearchService.findAuthorityByUserid(userId);
//        Map<String, Object> all = costCheckSearchService.getAll(pageNum, pageSize, authority);
//        return all;
//    }
//
//    /**
//     * 根据关键字模糊查询
//     * @param response
//     * @param request
//     * @return
//     */
//    @PostMapping("/key")
//    public Map<String,Object> getListByKey(HttpServletResponse response,HttpServletRequest request){
//        AxiosUtil.setCors(response,request);
//        String key = request.getParameter("key");
//        String pageSizeStr = request.getParameter("pageSize");
//        String pageNumStr = request.getParameter("pageNum");
//        Integer userId = Integer.valueOf(request.getParameter("userId"));
//        String authority = costCheckSearchService.findAuthorityByUserid(userId);
//        Map<String, Object> map = costCheckSearchService.seachByKey(key,Integer.parseInt(pageNumStr),Integer.parseInt(pageSizeStr), authority);
//        map.put("success",true);
//        return map;
//    }
//
//    @PostMapping("/keys")
//    public Map<String,Object> getListByKeys(HttpServletResponse response,HttpServletRequest request){
//        AxiosUtil.setCors(response,request);
//        Enumeration<String> parameterNames = request.getParameterNames();
//        if (null != parameterNames && parameterNames.hasMoreElements()){
//            String s = parameterNames.nextElement();
//            CostCheckSearchKeysVo searchKeysVo = (CostCheckSearchKeysVo)MyMapperUtil.getObject(s, CostCheckSearchKeysVo.class);
//            if (null != searchKeysVo.getParams().getKeys().getCostForm() && 3 ==searchKeysVo.getParams().getKeys().getCostForm()){
//                searchKeysVo.getParams().getKeys().setIsLend(1);
//            } else if (null != searchKeysVo.getParams().getKeys().getCostForm() && 4 ==searchKeysVo.getParams().getKeys().getCostForm()){
//                searchKeysVo.getParams().getKeys().setCostForm(3);
//                searchKeysVo.getParams().getKeys().setIsLend(2);
//            }
//            String authority = costCheckSearchService.findAuthorityByUserid(searchKeysVo.getParams().getKeys().getUserId());
//            searchKeysVo.getParams().getKeys().setAuthority(authority);
//            Map<String, Object> map = costCheckSearchService.searchByKeys(searchKeysVo);
//            map.put("success",true);
//            return map;
//        }
//        return null;
//    }
//
//    @GetMapping("/getLinkCost")
//    public List<CostDomain> getLinkCost(HttpServletResponse response, HttpServletRequest request){
//        AxiosUtil.setCors(response,request);
//        List<CostDomain> list = costCheckSearchService.getLinkCost();
//        return list;
//    }
//}
