package com.blt.other.module.auth.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.blt.other.module.auth.model.OaCompany;
import com.blt.other.module.auth.model.OaDepartment;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
public interface IOaDepartmentService extends IService<OaDepartment> {


    /**
     * <p>
     * 获取百伦公司主体下面的一级部门列表
     * </p>
     *
     * @param companyId 公司主体id
     * @return 一级部门列表
     */
    List<OaDepartment> primaryDepartment(@NonNull Integer companyId);


    /**
     * <p>
     * 修改部门审核人
     * </p>
     *
     * @param userId                    当前用户id
     * @param oaDepartmentId            oa部门id
     * @param departmentReviewerUserIds 部门审核oa userid list
     */
    void modifyDepartmentReviewer(Integer userId, Integer oaDepartmentId, List<Integer> departmentReviewerUserIds);

    /**
     * 获取百伦所有部门
     *
     * @return 所有部门
     */
    List<OaDepartment> allOaDepartment();

    /**
     * 查询部门树
     *
     * @return 部门树
     */
    List<OaCompany> queryTree();

    /**
     * 获取二级部门
     *
     * @param primaryDepartmentId 一级部门id
     * @return 二级部门列表
     */
    List<OaDepartment> secondDepartment(Integer primaryDepartmentId);
}
