package com.bailuntec.cost.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
public class CostDto {


    // 费用单编号
    private Integer id;
    @ApiModelProperty("费用单编号")
    private String costNo;
    @ApiModelProperty("费用计划编号")
    private String costPlanNo;
    @ApiModelProperty("主体编号")
    private String companyNo;
    @ApiModelProperty("主体名称")
    private String companyName;

    @ApiModelProperty("类型编号")
    private String typeNo;
    @ApiModelProperty("类型标题")
    private String typeName;

    @ApiModelProperty("会计一级科目")
    private String accountingSubjectNo;
    @ApiModelProperty("会计一级科目")
    private String accountingSubjectName;

    @ApiModelProperty("创建人id")
    private Integer createUserid;
    @ApiModelProperty("创建人编号")
    private String createUsercode;
    @ApiModelProperty("创建人名称")
    private String createUsername;
    @ApiModelProperty("费用单备注")
    private String costRemark;
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    //    @ApiModelProperty("关联子单")puh
//    @Deprecated
//    private String sonCostNo;
    @ApiModelProperty("关联父单")
    private String supCostNo;

    @ApiModelProperty("费用单状态 0 待提交 1- 待财务审核 2待出纳付款 3被驳回 4已支付 5已作废  6-待部门审核 7-待财务审核 8-待最终审核人审核")
    private Integer costStatus;

    @ApiModelProperty("文件地址")
    private String filePath;
    @ApiModelProperty("补充材料地址")
    private String morFilePath;
    @ApiModelProperty("补充信息")
    private String morRemark;

    @ApiModelProperty("费用总金额")
    private BigDecimal amount;

    @ApiModelProperty("二级物流供应商ID")
    private Integer subLogisticsSupplierId;
    @ApiModelProperty("一级物流供应商ID")
    private Integer logisticsSupplierId;

    @ApiModelProperty("收款银行（平台）")
    private String bankName;
    @ApiModelProperty("收款账户")
    private String bankCard;
    @ApiModelProperty("收款用户名")
    private String bankCardUser;
    @ApiModelProperty("收款/付款单位")
    private String bankCompany;


    @ApiModelProperty("1 付款费用 2 收款费用 3 借支/借还")
    private Integer costForm;
    @ApiModelProperty("1 借支 2 借还")
    private Integer isLend;
    @ApiModelProperty("1 未还 2 部分还款  3 待补差额  4 结清")
    private Integer lendStatus;

    @ApiModelProperty("付款理由")
    private String costReason;
    @ApiModelProperty("驳回原因")
    private String rejectReason;


    @ApiModelProperty("借支单已还金额")
    private BigDecimal hadPay;
    @ApiModelProperty("借支单补偿金额")
    private BigDecimal compensate;
    @ApiModelProperty("冲销金额 （借支单币种）")
    private BigDecimal counteract;
    @ApiModelProperty("借还单余额 （借支单币种）")
    private BigDecimal lendBalance;
    @ApiModelProperty("对应借支单币种）")
    private String dic;


    @ApiModelProperty("借还单冲销金额 ( 支付币种 )")
    private BigDecimal payCounteract;
    @ApiModelProperty("借还单余额 （ 支付币种 ）")
    private BigDecimal payLendBalance;
    @ApiModelProperty("计划金额 （ 支付币种 ）")
    private BigDecimal payPlanAmount;
    @ApiModelProperty("支付币种")
    private String payDic;
    @ApiModelProperty("借还单 借还支付币种 -> 借支币种汇率")
    private BigDecimal payCur;

    @ApiModelProperty("0 不抵扣个税  1 抵扣个税")
    private Integer isTax;

    @ApiModelProperty("出纳系统 detailKey")
    private String detailKey;

    @ApiModelProperty("支付者用户ID")
    private Integer payUserId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("支付时间")
    private Date payTime;

    @ApiModelProperty("转人民币汇率")
    private BigDecimal toRmbRate;
    @ApiModelProperty("费用单人民币总金额")
    private BigDecimal amountRmb;

    @ApiModelProperty("公司主体value")
    private Integer companyValue;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("财务审核时间")
    private Date auditTime;

    @ApiModelProperty("费用单发票状态编号")
    private Integer hasInvoice;

    @ApiModelProperty("驳回类型")
    private Integer rejectType;

    @ApiModelProperty("财务驳回时间")
    private Date rejectTime;

    @ApiModelProperty("")
    private String cashierFilePath;

    @ApiModelProperty("")
    private String cashierDownloadPath;

    @ApiModelProperty("费用来源 1-默认 2-WMS 3-调拨系统")
    private String sourceFrom;

    @ApiModelProperty("项目")
    private String projectType;

    @ApiModelProperty("客户编号")
    private String customerNum;

    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty("附加字段")
    private List<CostAttach> attach;

    @ApiModelProperty("费用模版id")
    private Integer costTemplateId;

    private LocalDateTime lastModifyDate;

    @ApiModelProperty("能否审核")
    @TableField(exist = false)
    private Boolean canAudit;

    @ApiModelProperty("借支单，还款申请金额，包括已还的和申请中 ，借支单币种。")
    private BigDecimal repaymentAppliedAmount;

    @TableField(exist = false)
    private Integer primaryDepartmentId;
    @TableField(exist = false)
    private String primaryDepartmentName;

    @ApiModelProperty("最终审核人")
    private String finalReviewerUserName;
    @ApiModelProperty("财务审核人")
    private String financialFinalReviewerUserName;
    @ApiModelProperty("部门审核人")
    private String departmentReviewerUserName;
    @ApiModelProperty("行政审核人")
    private String hrReviewerUserName;

    private String costStatusDto; // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private String fileName; // 文件名
    private String morFileName; // 补充材料文件名
    private String amountDto;
    private String isLendDto;// 0 普通费用  1 借支  2 借还
    private String costFormDto; // 费用类型
    private String lendStatusDto;
    private String dicDto; // 币种
    private String payPlanAmountDto;
    private String payDicDto; // 支付币种
    private String isTaxStr; // 0 不抵扣个税  1 抵扣个税


    private String lendType;


    @TableField(exist = false)
    private String costCurrentReviewer;


    @TableField(exist = false)
    private CostTemplateDto costTemplate;

}
