package com.blt.other.module.supplier.controller;

import com.blt.other.common.util.AxiosUtil;
import com.blt.other.database.model.BuyUserDomain;
import com.blt.other.module.supplier.service.BuyUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("buyUser")
public class BuyUserController {

    @Autowired
    private BuyUserService buyUserService;

    @GetMapping("getBuyUserId/{userid}")
    public BuyUserDomain getBuyUserByUserId(@PathVariable("userid") String userid){
        Integer buyuserid = Integer.parseInt(userid);
        BuyUserDomain buyUser = buyUserService.getBuyUserByUserId(buyuserid);
        return buyUser;
    }

    @GetMapping("getBuyUserList")
    public Map<String,Object> getBuyUserList(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        List<BuyUserDomain> buyUserDomainList = buyUserService.getBuyUserList();

        result.put("success",true);
        result.put("buyUsers",buyUserDomainList);
        return result;
    }
}
