package com.blt.other.module.sys.service.impl;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.service.IOaCompanyService;
import com.blt.other.module.sys.dto.request.SpecDepartmentCheckConfigImportExcelItem;
import com.blt.other.module.cost.service.CostCompanyService;
import com.blt.other.module.sys.model.SpecDepartmentCheckConfig;
import com.blt.other.module.sys.service.ISpecDepartmentCheckConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/13 3:27 下午
 */
public class SpecDepartmentCheckConfigExcelItemListener extends AnalysisEventListener<SpecDepartmentCheckConfigImportExcelItem> {

    private final ISpecDepartmentCheckConfigService specDepartmentCheckConfigService;
    private final CostCompanyService costCompanyService;
    private final IOaCompanyService oaCompanyService;
    private final OaDepartmentMapper oaDepartmentMapper;


    private static final Logger LOGGER = LoggerFactory.getLogger(SpecDepartmentCheckConfigExcelItemListener.class);

    SpecDepartmentCheckConfigExcelItemListener(ISpecDepartmentCheckConfigService specDepartmentCheckConfigService,
                                               CostCompanyService costCompanyService,
                                               IOaCompanyService oaCompanyService,
                                               OaDepartmentMapper oaDepartmentMapper) {
        this.specDepartmentCheckConfigService = specDepartmentCheckConfigService;
        this.costCompanyService = costCompanyService;
        this.oaCompanyService = oaCompanyService;
        this.oaDepartmentMapper = oaDepartmentMapper;
    }

    private static final int BATCH_COUNT = 2000;
    List<SpecDepartmentCheckConfigImportExcelItem> list = new ArrayList<>();

    @Override
    public void invoke(SpecDepartmentCheckConfigImportExcelItem data, AnalysisContext context) {
        LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
        list.add(data);
        if (list.size() >= BATCH_COUNT) {
            syncData();
            list.clear();
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        syncData();
        LOGGER.info("所有数据解析完成！");
    }

    private void syncData() {
        LOGGER.info("{}条数据，开始存储数据库！", list.size());
        List<SpecDepartmentCheckConfig> specDepartmentCheckConfigList = list.stream()
                .map(specDepartmentCheckConfigImportExcelItem -> {
                    SpecDepartmentCheckConfig specDepartmentCheckConfig = new SpecDepartmentCheckConfig();

                    specDepartmentCheckConfig.setCostCompanyName(specDepartmentCheckConfigImportExcelItem.getCostCompanyName());
                    specDepartmentCheckConfig.setCostCompanyId(costCompanyService.costCompanyMap().get(specDepartmentCheckConfigImportExcelItem.getCostCompanyName()).getId());

                    specDepartmentCheckConfig.setOaCompany(specDepartmentCheckConfig.getOaCompany());
                    specDepartmentCheckConfig.setOaCompanyId(oaCompanyService.companyDict().get(specDepartmentCheckConfigImportExcelItem.getOaCompany()).getOaCompanyId());

                    specDepartmentCheckConfig.setReviewerDepartmentId(oaDepartmentMapper.selectByName(specDepartmentCheckConfigImportExcelItem.getReviewerDepartmentName()).getDepartmentId());
                    specDepartmentCheckConfig.setReviewerDepartmentName(specDepartmentCheckConfigImportExcelItem.getReviewerDepartmentName());

                    specDepartmentCheckConfig.setLastUpdateTime(LocalDateTime.now());
                    return specDepartmentCheckConfig;
                })
                .filter(specDepartmentCheckConfig -> specDepartmentCheckConfig.getCostCompanyId() != null)
                .filter(specDepartmentCheckConfig -> specDepartmentCheckConfig.getOaCompanyId() != null)
                .filter(specDepartmentCheckConfig -> specDepartmentCheckConfig.getReviewerDepartmentId() != null)
                .collect(Collectors.toList());


        specDepartmentCheckConfigService.saveBatch(specDepartmentCheckConfigList);
        LOGGER.info("存储数据库成功！");
    }
}
