package com.blt.other.module.auth.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/13 3:33 下午
 */
@Data
public class CompanyReviewerListReq {

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("分页大小")
    private Integer pageSize;

    @ApiModelProperty("最终审核人id")
    private Integer finalReviewerUserId;

    @ApiModelProperty("财务审核人id")
    private Integer financialReviewerUserId;

    @ApiModelProperty("修改人id")
    private Integer modifyUserId;

    @ApiModelProperty("财务主体no")
    private String companyNo;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    @ApiModelProperty("修改时间上界")
    private LocalDateTime startTime;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    @ApiModelProperty("修改时间下界")
    private LocalDateTime endTime;
}
