package com.bailuntec.api.bailuntec.oa;

import com.bailuntec.api.Config;
import com.bailuntec.api.amazon.api.JsonUtilByFsJson;
import com.bailuntec.api.bailuntec.oa.response.ExchangeRate;
import com.bailuntec.api.common.BltResponseUtil;
import feign.Feign;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.support.SpringMvcContract;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/29 6:04 下午
 */

@Slf4j
class OaApiTestNoSpring {


    @Test
    void getAllUser() {
    }

    @Test
    void getDeparmentList() {
    }

    @Test
    void getExchangeRate() {
        Config config = new Config();
        OaApi oaApi = Feign
                .builder()
                .decoder(config.feignDecoder())
                .contract(new SpringMvcContract())
                .target(OaApi.class, OaApi.class.getAnnotation(FeignClient.class).url());

        String exchangeRate = oaApi.getExchangeRate("CNY", "CNY");
        log.info(exchangeRate);
        ExchangeRate exchangeRate1 = JsonUtilByFsJson.jsonToBean(BltResponseUtil.filterColonAndBackslash(exchangeRate), ExchangeRate.class);
        log.info(exchangeRate1.toString());
    }
}
