package com.bailuntec.api.amazon.api;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * SAAS公司账号信息
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "DcBaseCompanyAccount对象", description = "SAAS公司账号信息")
public class DcBaseCompanyAccount implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "公司id")
    private Integer companyId;

    @ApiModelProperty(value = "账号id,唯一")
    private Integer accountId;

    @ApiModelProperty(value = "账号")
    private String accountName;

    @ApiModelProperty(value = "账号登录邮箱")
    private String accountEmail;

    @ApiModelProperty(value = "oms编码")
    private String omsCode;

    @ApiModelProperty(value = "oms账号")
    private String omsAccount;

    @ApiModelProperty(value = "平台Id")
    private Integer platformId;

    @ApiModelProperty(value = "平台(中文)")
    private String platformCn;

    @ApiModelProperty(value = "平台(英文)")
    private String platformEn;

    @ApiModelProperty(value = "站点Id")
    private Integer siteId;

    @ApiModelProperty(value = "站点(中文)")
    private String siteCn;

    @ApiModelProperty(value = "站点(英文)")
    private String siteEn;

    @ApiModelProperty(value = "授权JSON")
    private String authJson;

    @ApiModelProperty(value = "1#启用;0#禁用;")
    private Boolean status;

    @ApiModelProperty(value = "状态(中文)")
    private String statusCn;

    @ApiModelProperty(value = "SOAP授权方式的token信息")
    private String soapAuthToken;

    @ApiModelProperty(value = "授权状态:1#未授权;2#已授权;3#授权过期;")
    private Integer soapAuthStatus;

    @ApiModelProperty(value = "授权状态:1#未授权;2#已授权;3#授权过期;")
    private Integer authStatus;

    @ApiModelProperty(value = "扩展信息:json字符串,主要存放类似Amazon MarketPlace,Ebay PayPal信息等")
    private String extensionInfo;

    @ApiModelProperty(value = "开发者信息:json字符串,主要存放获取token的开发者信息")
    private String developerJson;

    @ApiModelProperty(value = "信息维护人")
    private String manager;

    @ApiModelProperty(value = "SellerId")
    private String sellerId;

    @ApiModelProperty(value = "Ebay广告API授权")
    private String ebayAdAuthJson;

    @ApiModelProperty(value = "数据中心-创建时间")
    private LocalDateTime bjCreate;

    @ApiModelProperty(value = "数据中心-更新时间")
    private LocalDateTime bjModified;

    @ApiModelProperty(value = "Amazon广告API授权")
    private String amazonAdAuthJson;

    @TableField(exist = false)
    private AmazonAdAuth amazonAdAuth;


}
