package com.bailuntec.api.amazon.api;

import com.alibaba.fastjson.JSON;
import com.bailuntec.api.TestApplication;
import com.bailuntec.api.amazon.AmazonAdApi;
import com.bailuntec.api.amazon.request.*;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/24 11:24 上午
 */
@EnableHystrix
@ActiveProfiles(value = "test")
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = TestApplication.class)
public class AmazonAdApiTest {

    @Resource
    AmazonAdApi amazonAdApi;
    @Resource
    DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper;

    @Value("${metrics}")
    String metrics;

    private DcBaseCompanyAccount dcBaseCompanyAccount;

    private AmazonAdAuth amazonAdAuth;

    @Before
    public void setUp() {
        dcBaseCompanyAccount = dcBaseCompanyAccountMapper.selectOne(
                new LambdaQueryWrapper<DcBaseCompanyAccount>().eq(DcBaseCompanyAccount::getAccountId, 638)
        );
        amazonAdAuth = JsonUtilByFsJson.jsonToBean(dcBaseCompanyAccount.getAmazonAdAuthJson(), AmazonAdAuth.class);

    }

    @Test
    public void report() {
        AmazonProductsReportReq req = new AmazonProductsReportReq();
        req.setReportDate("20200918");
        req.setMetrics(metrics);


        log.info(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()).toString());
        log.info(JsonUtilByFsJson.beanToJson(req));
        log.info(amazonAdAuth.getAccessToken());
        log.info(amazonAdAuth.getClientId());
        log.info(amazonAdAuth.getProfileId());

        String reportResp = amazonAdApi.report(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()),
                req,
                "productAds",
                amazonAdAuth.getAccessToken(),
                amazonAdAuth.getClientId(),
                amazonAdAuth.getProfileId());

        log.info(JsonUtilByFsJson.beanToJson(reportResp));


    }

    @Test
    public void reportBrand() {
        AmazonBrandReportReq req = new AmazonBrandReportReq();
        req.setReportDate("20200818");
        req.setMetrics("campaignId,campaignName,campaignStatus,cost");


        log.info(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()).toString());
        log.info(JsonUtilByFsJson.beanToJson(req));
        log.info(amazonAdAuth.getAccessToken());
        log.info(amazonAdAuth.getClientId());
        log.info(amazonAdAuth.getProfileId());

        String reportResp = amazonAdApi.reportBrand(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()),
                req,
                "campaigns",
                amazonAdAuth.getAccessToken(),
                amazonAdAuth.getClientId(),
                amazonAdAuth.getProfileId());

        log.info(JsonUtilByFsJson.beanToJson(reportResp));
    }


    public void reportBrandVideo() {
        AmazonBrandVideoReportReq req = new AmazonBrandVideoReportReq();
        req.setReportDate("20200818");
        req.setMetrics("campaignId,campaignName,campaignStatus,cost");
        req.setCreativeType("video");


        log.info(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()).toString());
        log.info(JsonUtilByFsJson.beanToJson(req));
        log.info(amazonAdAuth.getAccessToken());
        log.info(amazonAdAuth.getClientId());
        log.info(amazonAdAuth.getProfileId());

        String reportResp = amazonAdApi.reportBrandVideo(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()),
                req,
                "campaigns",
                amazonAdAuth.getAccessToken(),
                amazonAdAuth.getClientId(),
                amazonAdAuth.getProfileId());

        log.info(JsonUtilByFsJson.beanToJson(reportResp));
    }

    @Test
    public void reportDisplay() {
        AmazonDisplayReportReq req = new AmazonDisplayReportReq();
        req.setReportDate("20200818");
        req.setMetrics("campaignName,campaignId,impressions,clicks,cost,currency,attributedConversions1d,attributedConversions7d,attributedConversions14d,attributedConversions30d,attributedConversions1dSameSKU,attributedConversions7dSameSKU,attributedConversions14dSameSKU,attributedConversions30dSameSKU,attributedUnitsOrdered1d,attributedUnitsOrdered7d,attributedUnitsOrdered14d,attributedUnitsOrdered30d,attributedSales1d,attributedSales7d,attributedSales14d,attributedSales30d,attributedSales1dSameSKU,attributedSales7dSameSKU,attributedSales14dSameSKU,attributedSales30dSameSKU");
        req.setTactic("T00020");

        log.info(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()).toString());
        log.info(JsonUtilByFsJson.beanToJson(req));
        log.info(amazonAdAuth.getAccessToken());
        log.info(amazonAdAuth.getClientId());
        log.info(amazonAdAuth.getProfileId());

        String reportResp = amazonAdApi.reportDisPlay(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()),
                req,
                "productAds",
                amazonAdAuth.getAccessToken(),
                amazonAdAuth.getClientId(),
                amazonAdAuth.getProfileId());

        log.info(JsonUtilByFsJson.beanToJson(reportResp));
    }


    @org.junit.Test
    public void reportStatus() {
        log.info(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()).toString());

        log.info(amazonAdAuth.getAccessToken());
        log.info(amazonAdAuth.getClientId());
        log.info(amazonAdAuth.getProfileId());

        String resp = amazonAdApi.reportStatus(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()),
                "amzn1.sdAPI.v1.p1.5F6C1A21.1dabb7c5-2873-44a8-8655-6ce3095a7171",
                amazonAdAuth.getAccessToken(),
                amazonAdAuth.getClientId(),
                amazonAdAuth.getProfileId());

        log.info(JsonUtilByFsJson.beanToJson(resp));

    }


    @org.junit.Test
    public void reportDownload() {

        log.info(AmazonURI.getAmazonAdSiteUri(dcBaseCompanyAccount.getSiteEn()).toString());
        log.info(amazonAdAuth.getAccessToken());
        log.info(amazonAdAuth.getClientId());
        log.info(amazonAdAuth.getProfileId());

        byte[] response = amazonAdApi.reportDownload(AmazonURI.getAmazonAdSiteUri("FR"),
                "amzn1.clicksAPI.v1.p35691.5FACEED9.b78c781c-3cd5-4b7d-966e-4174c697e951",
                amazonAdAuth.getAccessToken(),
                amazonAdAuth.getClientId(),
                amazonAdAuth.getProfileId());

        Assert.assertNotNull(response);

        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(response))) {


            Type type = new TypeToken<List<DcBaseFinanceAmazonAdProduct>>() {
            }.getType();

            List<DcBaseFinanceAmazonAdProduct> reportDownloadRespList = JSON.parseObject(gzipInputStream, type);

            log.info(JsonUtilByJackson.writeValueAsString(reportDownloadRespList));

            List<DcBaseFinanceAmazonAdProduct> filterResp = reportDownloadRespList.stream()
                    .filter(Objects::nonNull)
                    .filter(reportDownloadResp -> "47434150834738".equals(reportDownloadResp.getSku())).collect(Collectors.toList());


            log.info(JsonUtilByJackson.writeValueAsString(filterResp));
            log.info("总计：{}", filterResp.stream().map(DcBaseFinanceAmazonAdProduct::getCost).reduce(BigDecimal.ZERO, BigDecimal::add));
            log.info("总计：{}", reportDownloadRespList.stream()
                    .filter(item -> item.getCost() != null)
                    .map(DcBaseFinanceAmazonAdProduct::getCost).reduce(BigDecimal.ZERO, BigDecimal::add));

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
