package com.bailuntec.api.wx;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Author: li.yanlin
 * @Description： 企业微信接口
 * @Date: Created in 2021-11-17
 * @Modified by:
 */
@FeignClient(name = "qyWxApi", url = "https://qyapi.weixin.qq.com")
public interface QyWxApi {

    /**
     * 发送机器人消息
     * 消息体构建 QyMsgContent ⬇
     * @see  com.bailuntec.api.wx.request.QyMsgContent
     * @param key 机器人key
     * @param msg 消息体
     * @return
     */
    @PostMapping(value = "/cgi-bin/webhook/send?key={key}", consumes = MediaType.APPLICATION_JSON_VALUE)
    Void send(@PathVariable(name = "key") String key, @RequestBody String msg);
}
