package com.bailuntec.api.bailuntec.www;

import com.bailuntec.api.bailuntec.www.response.GetExchangeRateByCurAndDateResp;
import com.bailuntec.api.bailuntec.cw.response.GetPlatformResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/28 1:33 下午
 */
@FeignClient(name = "bailuntec", url = "http://www.bailuntec.com/", fallback = BailuntecApi.BailuntecApiFallback.class)
public interface BailuntecApi {

    /**
     * <p>
     * 获取费率接口
     * </p>
     *
     * @param fromCur 源费率
     * @param toCur   目标费率
     * @param date    日期
     * @return 费率响应
     */
    @GetMapping("/Api/ExchangeRate/GetExchangeRateByCurAndDate")
    GetExchangeRateByCurAndDateResp getExchangeRateByCurAndDate(@RequestParam("fromCur") String fromCur,
                                                                @RequestParam("toCur") String toCur,
                                                                @RequestParam("date") String date);

    /**
     * <p>请求销售平台同步百伦接口</p>
     *
     * @return 销售平台
     */
    @GetMapping("/api/PlatformSite/GetPlatformResp")
    List<GetPlatformResp> getPlatformResp();

    @Component
    class BailuntecApiFallback implements BailuntecApi {

        @Override
        public GetExchangeRateByCurAndDateResp getExchangeRateByCurAndDate(String fromCur, String toCur, String date) {
            GetExchangeRateByCurAndDateResp resp = new GetExchangeRateByCurAndDateResp();
            resp.setRate(new BigDecimal("-1"));
            resp.setToCurName(fromCur + "->" + toCur);
            resp.setCreateTime(LocalDateTime.now());
            return resp;
        }

        @Override
        public List<GetPlatformResp> getPlatformResp() {
            return null;
        }
    }
}
