package com.bailuntec.api.bailuntec.wms.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/29 11:32 上午
 */
@Data
public class CostFirstResult {

    private Integer currentPage;

    private Integer pageCount;

    private List<CostFirstData> data;

    @Data
    public static class CostFirstData {

        @JsonProperty("channelOrderNo")
        private String channelOrderId;

        @JsonProperty("orderCode")
        private String transferOrderId;

        @JsonProperty("id")
        private Integer channelId;

        @JsonProperty("boxCode")
        private String boxId;

        @JsonProperty("wareCode")
        private String warehouseCode;

        private List<CostFirstSku> skus;

        //燃油附加费
        @JsonProperty("fuelFee")
        private BigDecimal costFuel;

        //原始重量邮费
        @JsonProperty("weightFee")
        private BigDecimal costWeight;

        //清关费
        @JsonProperty("customsClearanceFee")
        private BigDecimal costCustomsClearance;

        //关税预付
        @JsonProperty("dutyFee")
        private BigDecimal costDuty;

        //报关费
        @JsonProperty("clearanceGoodsFee")
        private BigDecimal costGoodsClearance;

        //总费用
        @JsonProperty("moneyRMB")
        private BigDecimal costFirst;

        @JsonProperty("operationTime")
        private LocalDateTime operationTime;

        @JsonProperty("stateId")
        private Integer stateId;

        @JsonProperty("stateName")
        private String stateName;
    }

    @Data
    public static class CostFirstSku {

        @JsonProperty("sku")
        private String bailunSku;

        @JsonProperty("count")
        private Integer quantity;
    }

}
