package com.bailuntec.api.bailuntec.wms;

import com.bailuntec.api.bailuntec.wms.response.Logistics;
import com.bailuntec.api.bailuntec.wms.response.LogisticsReconciliation;
import com.bailuntec.api.bailuntec.wms.response.WmsLogisticsInfo;
import com.bailuntec.api.bailuntec.wms.response.WmsLogisticsReconciliationInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/6 4:10 下午
 */
@FeignClient(name = "wms", url = "http://wms.bailuntec.com/")
public interface WmsApi {


    /**
     * <p>
     * 调用wms系统库存接口
     * </p>
     *
     * @param logistics req
     * @return wms系统库存
     */
    @PostMapping("/api/services/app/LogisticsReconciliationService/GetNormalDataQuery")
    WmsLogisticsInfo getNormalDataQuery(@RequestBody Logistics logistics);

    /**
     * <p>
     * 调用wms物流费接口
     * </p>
     *
     * @param logisticsReconciliation req
     * @return wms物流费
     */
    @PostMapping("/api/services/app/LogisticsReconciliationService/GetBaseDataQuery")
    WmsLogisticsReconciliationInfo getBaseDataQuery(@RequestBody LogisticsReconciliation logisticsReconciliation);
}


