package com.bailuntec.api.bailuntec.wms;

import com.bailuntec.api.bailuntec.wms.request.WmsPageRequest;
import com.bailuntec.api.bailuntec.wms.response.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.time.format.DateTimeFormatter;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/29 10:37 上午
 */
@FeignClient(name = "wms2", url = "http://api.wms.bailuntec.com/")
public interface WmsApi2 {


    /**
     * <p>获取调拨单</p>
     *
     * @param startTime 开始时间 格式{@link DateTimeFormatter#ISO_LOCAL_DATE_TIME}
     * @param endTime   结束时间 格式{@link DateTimeFormatter#ISO_LOCAL_DATE_TIME}
     * @return 调拨单
     */
    @GetMapping("/api/services/app/AllotBoxService/DateCenterGetBoxCosts")
    CostFirstResult DateCenterGetBoxCosts(@RequestParam("startTime") String startTime,
                                          @RequestParam("endTime") String endTime);

    /**
     * <p>获取已完成的调拨单</p>
     *
     * @param startTime 完成时间start 格式{@link DateTimeFormatter#ISO_LOCAL_DATE_TIME}
     * @param endTime   完成时间end 格式{@link DateTimeFormatter#ISO_LOCAL_DATE_TIME}
     * @return 已完成的调拨单
     */
    @GetMapping("/api/services/app/AllotBoxService/DateCenterGetBoxCostsByCompleteTime")
    CostFirstResult DateCenterGetBoxCostsByCompleteTime(@RequestParam("startTime") String startTime,
                                                        @RequestParam("endTime") String endTime);


    /**
     * <p>
     * 调用wms系统FBA库存接口
     * </p>
     *
     * @param request req
     * @return fba库存
     */
    @PostMapping("/api/services/app/ThirdStockFbaService/GetFbaStocks")
    WmsResult<FbaStockData> getFbaStocks(@RequestBody WmsPageRequest request);


    /**
     * <p>
     * 调用wms系统库存接口
     * </p>
     *
     * @param root req
     * @return 库存
     */
    @PostMapping("/api/services/app/WMSStockService/SearchAllProductStockByPage")
    WmsResult<WmsStockInfo> searchAllProductStockByPage(@RequestBody Root root);
}
