package com.bailuntec.api.bailuntec.oms.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class PickingOrder {

    @JsonProperty("pickingNo")
    private String pickOrderId;

    @JsonProperty("trackingProvider")
    private String trackingProvider;

    @JsonProperty("trackingNo")
    private String trackingOrderId;

    @JsonProperty("shippingStatus")
    private String shippingStatus;

    @JsonProperty("creationTime")
    private LocalDateTime createTime;

    @JsonProperty("shippingTime")
    private LocalDateTime shippingTime;

    @JsonProperty("warehouse")
    private Warehouse warehouse;

    @JsonProperty("logistics")
    private Logistics logistics;

    @JsonProperty("pickingOrderItems")
    private List<PickingItem> pickingItems;

    @JsonProperty("shippingCost")
    private BigDecimal costShipping;

    @JsonProperty("packagingCost")
    private BigDecimal costPackaging;

    @JsonProperty("outputWeight_KG")
    private BigDecimal outboundWeight;

    @JsonProperty("isPushedThirdSys")
    private Boolean hasPushed;
}
