package com.bailuntec.api.ebay.seller.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-19
 * @Modified by:
 */
@Data
public class EbayTransactionRes {

    /*api响应字段*/
    private String href;

    private Integer limit;

    private String next;

    private Integer offset;

    private String prev;

    private Integer total;

    private List<Transaction> transactions;


}

/**
 * 交易
 */
@Data
class Transaction{
    private Amount amount;

    @ApiModelProperty("在此字段中返回的枚举值指示货币交易金额是卖方帐户的（CREDIT）还是（DEBIT）。 通常，SALE和CREDIT交易类型记入卖方帐户，而REFUND，DISPUTE，SHIPPING_LABEL和TRANSFER交易类型记入卖方帐户的借方。")
    private String bookingEntry;

    private Buyer buyer;

    private String feeType;

    private String orderId;

    private List<OrderLineItem> orderLineItems;

    @ApiModelProperty("此字符串值指示正在处理付款的实体。")
    private String paymentsEntity;

    private String payoutId;

    private List<Reference> references;

    @ApiModelProperty("与销售订单关联的销售记录号。销售记录号是在结帐时创建的Selling Manager / Selling Manager Pro标识符。")
    private String salesRecordReference;

    @ApiModelProperty("该金额是在从与订单相关的卖方付款中扣除销售费用之前的订单总金额。要确定将通过卖方付款支付的订单的实际金额，请从basePayoutAmount中减去totalFeeAmount。")
    private Amount totalFeeBasisAmount;
    
    private Amount totalFeeAmount;

    private String transactionDate;

    private String transactionId;

    private String transactionMemo;

    private String transactionStatus;

    private String transactionType;
}

/**
 * 货币
 */
@Data
class Amount{
    private String currency;

    @ApiModelProperty("转换前币种")
    private String convertedFromCurrency;

    private String convertedFromValue;

    private String exchangeRate;

    private String value;
}

/**
 * 买家
 */
@Data
class Buyer{
    private String username;
}

/**
 * sku行
 */
@Data
class OrderLineItem{
    private Amount amount;

    private String lineItemId;

    private List<Fee> marketplaceFees;
}

/**
 * 费用项
 */
@Data
class Fee{
    private Amount amount;
    
    private String feeMemo;

    private String feeType;
}

/**
 *
 */
@Data
class Reference{
    private String referenceId;

    private String referenceType;
}