package com.bailuntec.api.bailuntec.pps;

import com.bailuntec.api.TestApplication;
import com.bailuntec.api.amazon.api.JsonUtilByFsJson;
import com.bailuntec.api.bailuntec.pps.request.GetListingSkuMapPagesReq;
import com.bailuntec.api.bailuntec.pps.response.GetListingSkuMapPagesItem;
import com.bailuntec.api.bailuntec.pps.response.PpsPage;
import com.bailuntec.api.bailuntec.pps.response.PpsResult;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/22 4:36 下午
 */
@ActiveProfiles(value = "test")
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = TestApplication.class)
class PpsApiTest {

    @Resource
    PpsApi ppsApi;

    @Test
    void getListingSkuMapPages() {
        GetListingSkuMapPagesReq req = new GetListingSkuMapPagesReq();
        req.setBeginTime(LocalDateTime.now().minusDays(10));
        req.setEndTime(LocalDateTime.now());
        req.setPageIndex(1);
        req.setPageNumber(100);
        req.setPlatforms(Lists.newArrayList(0, 1));


        PpsResult<PpsPage<GetListingSkuMapPagesItem>> result = ppsApi.getListingSkuMapPages(req);
        log.info(JsonUtilByFsJson.beanToJson(result));
    }
}
