## 百伦api
封装所有Java项目需要用到的第三方服务和内部异构(.NET)服务的接口调用

### 如何使用
- 继承parent
```xml
<parent>
    <groupId>com.bailuntec</groupId>
    <artifactId>bailuntec-parent</artifactId>
    <version>1.0-SNAPSHOT</version>
</parent>
```

- 添加依赖
```xml
<dependency>
    <groupId>com.bailuntec</groupId>
    <artifactId>bailuntec-api</artifactId>
</dependency>
```

- 非spring环境
```java
@Slf4j
class PamsApiTestNoSpring {


    @Test
    void getAccountToken() {

        PamsApi pamsApi = FeignUtil.getInstance(PamsApi.class);
        PamsResult<List<GetAccountTokenResp>> result = pamsApi.getAccountToken();
        log.info(JsonUtilByFsJson.beanToJson(result));
    }
}
```

- springboot环境
```
@ActiveProfiles(value = "test")
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = TestApplication.class)
class PamsApiTest {

    @Resource
    PamsApi pamsApi;

    @Test
    void getAccountToken() {
        PamsResult<List<GetAccountTokenResp>> result = pamsApi.getAccountToken();
        log.info(JsonUtilByFsJson.beanToJson(result));
    }
}
```

### 技术栈
- pring-cloud-starter-openfeign 通过feign封装Api,以二方库形式提供能力,消费方通过接口方法调用
- spring-cloud-starter-netflix-hystrix hystrix 提供熔断能力
- jackson spring默认jackson作为序列化框架

### 项目目录
```
└── com
    └── bailuntec
        └── api
            ├── amazon      //亚马逊开放api feign抽象
            ├── bailuntec       //百伦内部api调用feign抽象
            │   ├── crm    //crm系统接口
            │   ├── cw     //财务系统接口 
            │   ├── fee     //费用系统接口
            │   ├── mj      //美甲系统
            │   ├── mjcg        //美甲采购
            │   ├── oa      //oa系统接口
            │   ├── oms     //订单系统接口
            │   ├── pams        //pams
            │   ├── pps     //刊登系统接口
            │   ├── purchase        //采购系统接口
            │   ├── sso     //单点登录接口
            │   ├── wms     //库存接口
            │   └── www     //百伦其他
            ├── config      //系统配置
            ├── ebay        //ebay开放api
            └── wish        //

```


### 如何开发

#### 创建feign接口
- 创建SpringMvc风格的接口
- 注解@FeignClient 指定name 和地址url
- @GetMapping @PostMapping 用法同springMvc
- @RequestBody @RequestParam @PathVariable 用法同springMvc
#### 熔断
- 创建熔断类继承feign接口实现熔断逻辑
- 熔断配置 @FeignClient fallback = 熔断类
```java
@FeignClient(name = "sso", url = "http://sso.bailuntec.com/", fallback = SsoApi.SsoApiFallback.class)
public interface SsoApi {

    /**
     * <p>调用公司信息接口</p>
     *
     * @return 公司信息
     */
    @GetMapping("/GetCompanys")
    SsoResult<List<GetCompanysResp>> getCompanys();

    /**
     * <p>调用公司员工信息接口</p>
     *
     * @return 公司员工信息
     */
    @GetMapping("/GetUserByCompany")
    SsoResult<GetUserByCompanyResp> getUserByCompany();

    @Component
    class SsoApiFallback implements SsoApi {

        @Override
        public SsoResult<List<GetCompanysResp>> getCompanys() {
            return new SsoResult<>();
        }

        @Override
        public SsoResult<GetUserByCompanyResp> getUserByCompany() {
            return new SsoResult<>();
        }
    }
}

```

#### 命名规范
- 入参定义:方法名+Req 。
- 出参定义:方法名+Resp。 
- api定义接口按照项目接口分类

#### 注意事项
- @RequestParam 需要显示指定value
- 有一些三方服务的api返回的不是规范json不能直接序列化 需要用string接受然后再代码转换。
- 该类库只是对异构内部服务（主要是.Net）和三方接口的外部接口调用抽象，所以不存在feign的服务调用负载等，
统一通过@FeignClient的url参数直接指定调用地址。

#### 待扩展
kubernetes 云原生扩展

### 参考文档
[open feign官方文档](https://docs.spring.io/spring-cloud-openfeign/docs/2.2.5.RELEASE/reference/html/)
