package com.bailuntec.api.amazon;

import com.bailuntec.api.amazon.request.AmazonBrandReportReq;
import com.bailuntec.api.amazon.request.AmazonBrandVideoReportReq;
import com.bailuntec.api.amazon.request.AmazonDisplayReportReq;
import com.bailuntec.api.amazon.request.AmazonProductsReportReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.bind.annotation.*;

import java.net.URI;

/**
 * <p>
 * 亚马逊接口响应报文没有Content-Type
 * 导致{@link org.springframework.web.client.HttpMessageConverterExtractor#extractData(ClientHttpResponse)}
 * 会将{@link org.springframework.http.MediaType}设置成application/octet-stream（期望是application/json）
 * 从而不能找到合适的解码器反序列化失败
 * </p>
 *
 * <p>暂时没有比较好的扩展方案 所以根据文档设置返回值类型 需要调用后再二次序列化</p>
 *
 * @author robbendev
 * @since 2020/8/20 3:30 下午
 */
@FeignClient(name = "amazonApi", url = "https://advertising-api.amazon.com")
public interface AmazonAdApi {


    /**
     * <p>
     * 生成亚马逊商品推广广告报告
     * </p>
     *
     * @param uri           亚马逊不同站点动态uri
     * @param req           入参数
     * @param authorization {@link AmazonAdAuth#getAccessToken()}
     * @param clientId      {@link AmazonAdAuth#getClientId()}
     * @param scope         {@link AmazonAdAuth#getProfileId()}
     * @return resp {@link com.bailuntec.domain.DcBaseFinanceAmazonAdProduct}
     */
    @PostMapping(value = "/v2/sp/{recordType}/report")
    String report(URI uri,
                  @RequestBody AmazonProductsReportReq req,
                  @PathVariable("recordType") String recordType,
                  @RequestHeader("Authorization") String authorization,
                  @RequestHeader("Amazon-Advertising-API-ClientId") String clientId,
                  @RequestHeader("Amazon-Advertising-API-Scope") String scope);


    /**
     * 生成亚马逊商品广告
     *
     * @param uri           亚马逊不同站点动态uri
     * @param req           入参数
     * @param recordType    报告类型
     * @param authorization {@link AmazonAdAuth#getAccessToken()}
     * @param clientId      {@link AmazonAdAuth#getClientId()}
     * @param scope         {@link AmazonAdAuth#getProfileId()}
     * @return resp {@link com.bailuntec.domain.DcBaseFinanceAmazonAdProduct}
     */
    @GetMapping("/sd/{recordType}/report")
    String reportDisPlay(URI uri,
                         @RequestBody AmazonDisplayReportReq req,
                         @PathVariable("recordType") String recordType,
                         @RequestHeader("Authorization") String authorization,
                         @RequestHeader("Amazon-Advertising-API-ClientId") String clientId,
                         @RequestHeader("Amazon-Advertising-API-Scope") String scope);


    /**
     * 生成亚马逊品牌推广报告
     *
     * @param uri           亚马逊不同站点动态uri
     * @param req           入参
     * @param recordType    报告类型
     * @param authorization {@link AmazonAdAuth#getAccessToken()}
     * @param clientId      {@link AmazonAdAuth#getClientId()}
     * @param scope         {@link AmazonAdAuth#getProfileId()}
     * @return {@link com.bailuntec.domain.DcBaseFinanceAmazonAdProduct}
     */
    @PostMapping("/v2/hsa/{recordType}/report")
    String reportBrand(URI uri,
                       @RequestBody AmazonBrandReportReq req,
                       @PathVariable(value = "recordType") String recordType,
                       @RequestHeader("Authorization") String authorization,
                       @RequestHeader("Amazon-Advertising-API-ClientId") String clientId,
                       @RequestHeader("Amazon-Advertising-API-Scope") String scope);

    /**
     * 生成亚马逊品牌推广（视频）报告
     *
     * @param uri           亚马逊不同站点动态uri
     * @param req           入参
     * @param recordType    报告类型
     * @param authorization {@link AmazonAdAuth#getAccessToken()}
     * @param clientId      {@link AmazonAdAuth#getClientId()}
     * @param scope         {@link AmazonAdAuth#getProfileId()}
     * @return {@link com.bailuntec.domain.DcBaseFinanceAmazonAdProduct}
     */
    @PostMapping("/v2/hsa/{recordType}/report")
    String reportBrandVideo(URI uri,
                            @RequestBody AmazonBrandVideoReportReq req,
                            @PathVariable(value = "recordType") String recordType,
                            @RequestHeader("Authorization") String authorization,
                            @RequestHeader("Amazon-Advertising-API-ClientId") String clientId,
                            @RequestHeader("Amazon-Advertising-API-Scope") String scope);


    /**
     * 查看报告状态
     *
     * @param uri           亚马逊广告动态uri
     * @param reportId      报告id
     * @param authorization {@link AmazonAdAuth#getAccessToken()}
     * @param clientId      {@link AmazonAdAuth#getClientId()}
     * @param scope         {@link AmazonAdAuth#getProfileId()}
     * @return resp {@link com.bailuntec.domain.JobAmazonAdLog}
     */
    @GetMapping("/v2/reports/{reportId}")
    String reportStatus(URI uri,
                        @PathVariable("reportId") String reportId,
                        @RequestHeader("Authorization") String authorization,
                        @RequestHeader("Amazon-Advertising-API-ClientId") String clientId,
                        @RequestHeader("Amazon-Advertising-API-Scope") String scope);

    /**
     * <p>
     * 下载亚马逊报告
     * </p>
     *
     * @param uri           亚马逊广告动态uri
     * @param reportId      报告id
     * @param authorization {@link AmazonAdAuth#getAccessToken()}
     * @param clientId      {@link AmazonAdAuth#getClientId()}
     * @param scope         {@link AmazonAdAuth#getProfileId()}
     * @return resp  {@link com.bailuntec.domain.JobAmazonAdLog}
     */
    @GetMapping(value = "/v1/reports/{reportId}/download")
    byte[] reportDownload(URI uri,
                          @PathVariable("reportId") String reportId,
                          @RequestHeader("Authorization") String authorization,
                          @RequestHeader("Amazon-Advertising-API-ClientId") String clientId,
                          @RequestHeader("Amazon-Advertising-API-Scope") String scope);

}
