package com.bailuntec.api;

import com.bailuntec.api.bailuntec.cw.CwApiJackson2HttpMeesageConverter;
import feign.codec.Decoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignFormatterRegistrar;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;

import java.time.format.DateTimeFormatter;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/12 2:41 下午
 */
@Configuration
@EnableFeignClients(basePackages = {"com.bailuntec.api"})
public class Config {


    private final DateTimeFormatter dateFormatter =
            DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private final DateTimeFormatter timeFormatter =
            DateTimeFormatter.ofPattern("HH:mm:ss");

    private final DateTimeFormatter dateTimeFormatter =
            DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Bean
    public Decoder feignDecoder() {
        CwApiJackson2HttpMeesageConverter cwApiJackson2HttpMeesageConverter = new CwApiJackson2HttpMeesageConverter();
        ObjectFactory<HttpMessageConverters> objectFactory = () -> new HttpMessageConverters(cwApiJackson2HttpMeesageConverter);
        return new SpringDecoder(objectFactory);
    }

    @Bean
    public FeignFormatterRegistrar feignFormatterRegistrar() {
        return new FeignFormatterRegistrar() {

            @Override
            public void registerFormatters(
                    FormatterRegistry formatterRegistry) {
                DateTimeFormatterRegistrar registrar =
                        new DateTimeFormatterRegistrar();
                registrar.setUseIsoFormat(false);
                registrar.setDateFormatter(dateFormatter);
                registrar.setTimeFormatter(timeFormatter);
                registrar.setDateTimeFormatter(dateTimeFormatter);
                registrar.registerFormatters(formatterRegistry);
            }
        };
    }
}
