package com.bailuntec.api.bailuntec.sso;

import com.bailuntec.api.bailuntec.sso.response.GetCompanysResp;
import com.bailuntec.api.bailuntec.sso.response.GetUserByCompanyResp;
import com.bailuntec.api.bailuntec.sso.response.SsoResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/29 10:37 上午
 */
@FeignClient(name = "sso", url = "http://sso.bailuntec.com/", fallback = SsoApi.SsoApiFallback.class)
public interface SsoApi {

    /**
     * <p>调用公司信息接口</p>
     *
     * @return 公司信息
     */
    @GetMapping("/GetCompanys")
    SsoResult<List<GetCompanysResp>> getCompanys();

    /**
     * <p>调用公司员工信息接口</p>
     *
     * @return 公司员工信息
     */
    @GetMapping("/GetUserByCompany")
    SsoResult<GetUserByCompanyResp> getUserByCompany();

    @Component
    class SsoApiFallback implements SsoApi {

        @Override
        public SsoResult<List<GetCompanysResp>> getCompanys() {
            return new SsoResult<>();
        }

        @Override
        public SsoResult<GetUserByCompanyResp> getUserByCompany() {
            return new SsoResult<>();
        }
    }
}
