package com.bailuntec.api.wx.request;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in 2021-11-17
 * @Modified by:
 */
@Slf4j
public class QyMsgContent {

    /**
     * 普通消息体
     *
     * @param content               消息体
     * @param mentioned_mobile_list @all，@单人需要手机号
     * @return
     */
    public static String getTextContent(String content, List<String> mentioned_mobile_list) {
        assert StringUtils.isNotBlank(content);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype", "text");

        JSONObject contentObj = new JSONObject();
        contentObj.put("content", content);
        if (mentioned_mobile_list != null)
            contentObj.put("mentioned_mobile_list", mentioned_mobile_list);
        jsonObject.put("text", contentObj);
        return jsonObject.toJSONString();
    }

    /**
     * markdown类型消息体，无法@用户
     *
     * @param content    消息主题
     * @param typeMsgMap 消息内容item
     * @return
     */
    public static String getMarkdownContent(String content, Map<String, String> typeMsgMap) {
        assert StringUtils.isNotBlank(content);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype", "markdown");

        JSONObject contentObj = new JSONObject();
        StringBuilder contentBuilder = new StringBuilder(content + "\n");
        if (typeMsgMap != null && !typeMsgMap.isEmpty()) {
            typeMsgMap.forEach((type, msg) -> {
                contentBuilder.append(">" + type + "：" + msg + "\n");
            });
        }
        contentObj.put("content", contentBuilder.toString());
        jsonObject.put("markdown", contentObj);
        log.info(jsonObject.toJSONString());
        return jsonObject.toJSONString();
    }

    public static String getMarkdownContent(String content, Map<String, String> typeMsgMap, Color color) {
        assert StringUtils.isNotBlank(content);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype", "markdown");

        JSONObject contentObj = new JSONObject();
        StringBuilder contentBuilder = new StringBuilder(content + "\n");
        if (typeMsgMap != null && !typeMsgMap.isEmpty()) {
            typeMsgMap.forEach((type, msg) -> {
                contentBuilder.append(">" + type + "：<font color=\"" + color.toString() + "\">" + msg + "</font>\n");
            });
        }
        contentObj.put("content", contentBuilder.toString());
        jsonObject.put("markdown", contentObj);
        log.info(jsonObject.toJSONString());
        return jsonObject.toJSONString();
    }

    public static enum Color {
        info,//绿色
        comment,//灰色
        warning//橙红色
    }
}
