package com.bailuntec.api.bailuntec.purchase;

import com.bailuntec.api.bailuntec.purchase.resp.*;
import feign.Headers;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.time.LocalDate;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/6 1:30 下午
 */
@FeignClient(name = "purchase", url = "http://api.purchase.bailuntec.com")
public interface PurchaseApi {

    /**
     * <p>
     * 调用采购单sku流水接口
     * </p>
     *
     * @param start    yyyy-MM-dd HH:mm:ss
     * @param end      yyyy-MM-dd HH:mm:ss
     * @param type     类型
     * @param pagesize page
     * @param page     page
     * @return 采购单sku流水
     */
    @GetMapping("/Api/GetPurchaseSkuForDataCenter")
    PurchaseResult<List<GetPurchaseSkuForDataCenterResp>> getPurchaseSkuForDataCenter(@RequestParam("start") String start,
                                                                                      @RequestParam("end") String end,
                                                                                      @RequestParam("type") Integer type,
                                                                                      @RequestParam("pagesize") Integer pagesize,
                                                                                      @RequestParam("page") Integer page);

    /**
     * <p>调用采购单sku详细信息接口</p>
     *
     * @param start    yyyy-MM-dd HH:mm:ss
     * @param end      yyyy-MM-dd HH:mm:ss
     * @param pagesize page
     * @param page     page
     * @return 采购单sku详细信息
     */
    @PostMapping(value = "/api/GetPagePurchaseSkuInfo")
    @Headers({"content-length: 0"})
    PurchaseResult<List<PurchaseDetailDto>> GetPagePurchaseSkuInfo(@RequestParam("start") String start,
                                                                   @RequestParam("end") String end,
                                                                   @RequestParam("pagesize") Integer pagesize,
                                                                   @RequestParam("page") Integer page);

    /**
     * 取供应商往来数据：应付账款和预付账款
     * @param startTime
     * @param endTime
     * @param supplierName
     * @param nothing
     * @return
     */
    @PostMapping(value = "/api/GetList_SupplierTransactionStatictis")
    PurchaseResult<List<SupplierTransactionDTO>> GetSupplierTransactionStatictis(@RequestParam("startTime") LocalDate startTime,
                                                                                 @RequestParam("endTime") LocalDate endTime,
                                                                                 @RequestParam("supplierName") String supplierName,
                                                                                 @RequestBody String nothing);

    @PostMapping(value = "api/GetList_SupplierTransactionExpress")
    PurchaseResult<List<LogisticsSupplierTransactionDTO>> GetSupplierTransactionExpress(@RequestParam("day") LocalDate day,
                                                                                        @RequestBody String nothing);
}

