package com.bailuntec.api.bailuntec.pams;

import com.bailuntec.api.bailuntec.pams.response.GetAccountTokenResp;
import com.bailuntec.api.bailuntec.pams.response.GetPayPalAccountsResp;
import com.bailuntec.api.bailuntec.pams.response.PamsResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/29 10:37 上午
 */
@FeignClient(name = "pams", url = "https://pams.bailuntec.com/")
public interface PamsApi {

    /**
     * <p>获取账户信息</p>
     *
     * @return 帐号信息
     */
    @GetMapping("/Api/GetAccountToken")
    PamsResult<List<GetAccountTokenResp>> getAccountToken();

    /**
     * <p>
     * 调用paypal账户授权信息接口
     * </p>
     *
     * @return paypal账户授权信息
     */
    @GetMapping("/Api/getPayPalAccounts")
    PamsResult<List<GetPayPalAccountsResp>> getPayPalAccounts();
}
